/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.monster;

import fuzs.enderzoology.EnderZoology;
import fuzs.enderzoology.world.entity.ai.goal.FollowMobOwnerGoal;
import fuzs.enderzoology.world.entity.monster.CompanionMob;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WitherCat
extends Monster
implements CompanionMob<Witch> {
    private static final float NORMAL_SCALE = 1.0f;
    private static final float ANGRY_SCALE = 2.0f;
    private static final float SCALE_INCREMENTS = 0.05f;
    private static final int MIN_DEAGGRESSION_TIME = 600;
    private static final EntityDataAccessor<Float> DATA_SCALE_ID = SynchedEntityData.defineId(WitherCat.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final ResourceLocation SPEED_MODIFIER_ATTACKING_ID = EnderZoology.id("attacking_speed_boost");
    private static final ResourceLocation HEALTH_MODIFIER_ATTACKING_ID = EnderZoology.id("attacking_health_boost");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_ID, 0.15, AttributeModifier.Operation.ADD_VALUE);
    private static final AttributeModifier HEALTH_MODIFIER_ATTACKING = new AttributeModifier(HEALTH_MODIFIER_ATTACKING_ID, 20.0, AttributeModifier.Operation.ADD_VALUE);
    private int targetLostTime = -600;
    private int ticksUntilNextAlert;
    private float scaleO;

    public WitherCat(EntityType<? extends WitherCat> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(6, (Goal)new FollowMobOwnerGoal((Mob)this, Witch.class, 1.25));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_SCALE_ID, (Object)Float.valueOf(1.0f));
        this.scaleO = 1.0f;
    }

    public void setTarget(@Nullable LivingEntity target) {
        if (target == null) {
            this.targetLostTime = this.tickCount;
        } else {
            this.targetLostTime = -600;
            if (this.getTarget() == null) {
                this.resetTicksUntilNextAlert();
            }
        }
        super.setTarget(target);
    }

    protected void customServerAiStep() {
        AttributeInstance movementSpeedAttribute = this.getAttribute(Attributes.MOVEMENT_SPEED);
        AttributeInstance maxHealthAttribute = this.getAttribute(Attributes.MAX_HEALTH);
        if (this.isAngry()) {
            if (!movementSpeedAttribute.hasModifier(SPEED_MODIFIER_ATTACKING.id())) {
                movementSpeedAttribute.addTransientModifier(SPEED_MODIFIER_ATTACKING);
            }
            if (!maxHealthAttribute.hasModifier(HEALTH_MODIFIER_ATTACKING.id())) {
                maxHealthAttribute.addTransientModifier(HEALTH_MODIFIER_ATTACKING);
                this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 120, 3));
            }
        } else {
            if (movementSpeedAttribute.hasModifier(SPEED_MODIFIER_ATTACKING.id())) {
                movementSpeedAttribute.removeModifier(SPEED_MODIFIER_ATTACKING);
            }
            if (maxHealthAttribute.hasModifier(HEALTH_MODIFIER_ATTACKING.id())) {
                maxHealthAttribute.removeModifier(HEALTH_MODIFIER_ATTACKING);
            }
        }
        this.maybeAlertCompanions();
        if (this.isAngry()) {
            if (this.getScale() < 2.0f) {
                this.setScale(Math.min(2.0f, this.getScale() + 0.05f));
            }
        } else if (this.getScale() > 1.0f) {
            this.setScale(Math.max(1.0f, this.getScale() - 0.05f));
        }
        super.customServerAiStep();
    }

    @Override
    public Mob getCompanionMob() {
        return this;
    }

    @Override
    public int getTicksUntilNextAlert() {
        return this.ticksUntilNextAlert;
    }

    @Override
    public void setTicksUntilNextAlert(int ticksUntilNextAlert) {
        this.ticksUntilNextAlert = ticksUntilNextAlert;
    }

    @Override
    public Class<Witch> getCompanionType() {
        return Witch.class;
    }

    public void refreshDimensions() {
        double d = this.getX();
        double e = this.getY();
        double f = this.getZ();
        super.refreshDimensions();
        this.setPos(d, e, f);
    }

    public float getScale() {
        return ((Float)this.entityData.get(DATA_SCALE_ID)).floatValue();
    }

    public float getScaleAmount(float tickDelta) {
        return Mth.lerp((float)tickDelta, (float)this.scaleO, (float)this.getScale());
    }

    private void setScale(float scale) {
        this.entityData.set(DATA_SCALE_ID, (Object)Float.valueOf(scale));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (DATA_SCALE_ID.equals(key)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(key);
    }

    public boolean isVisuallyAngry() {
        return this.getScale() != 1.0f;
    }

    private boolean isAngry() {
        return this.getTarget() != null || this.tickCount < this.targetLostTime + 600;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return super.isInvulnerableTo(source) || source.getEntity() instanceof Witch;
    }

    public boolean addEffect(MobEffectInstance effectInstance, @Nullable Entity entity) {
        if (!((MobEffect)effectInstance.getEffect().value()).isBeneficial() && entity instanceof Witch) {
            return false;
        }
        return super.addEffect(effectInstance, entity);
    }

    public boolean canBeAffected(@NotNull MobEffectInstance potion) {
        return potion.getEffect() != MobEffects.WITHER && super.canBeAffected(potion);
    }

    public void aiStep() {
        this.scaleO = this.getScale();
        super.aiStep();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return this.isAngry() ? SoundEvents.CAT_HISS : SoundEvents.CAT_STRAY_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.CAT_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.CAT_DEATH;
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }
}

