/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.monster;

import fuzs.enderzoology.core.CommonAbstractions;
import fuzs.enderzoology.init.ModEntityTypes;
import fuzs.enderzoology.init.ModRegistry;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AnimalArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FallenMount
extends AbstractHorse
implements Enemy {
    static final String TAG_HORSE_DATA = "HorseData";
    private static final EntityDataAccessor<Boolean> DATA_CONVERTING_ID = SynchedEntityData.defineId(FallenMount.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @Nullable
    private CompoundTag horseData;
    private int conversionTime;
    @Nullable
    private UUID conversionStarter;

    public FallenMount(EntityType<? extends AbstractHorse> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 5;
    }

    protected static String getEncodeId(Entity entity) {
        EntityType entityType = entity.getType();
        ResourceLocation resourceLocation = EntityType.getKey((EntityType)entityType);
        return entityType.canSerialize() && resourceLocation != null ? resourceLocation.toString() : null;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new MountRestrictSunGoal((PathfinderMob)this));
        this.goalSelector.addGoal(3, (Goal)new MountFleeSunGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2f, false){

            public boolean canUse() {
                return !this.mob.isVehicle() && super.canUse();
            }
        });
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractHorse.class, false, entity -> entity.getType().is(ModRegistry.FALLEN_MOUNT_TARGETS_ENTITY_TYPE_TAG)));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected int getBaseExperienceReward() {
        return this.xpReward;
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CONVERTING_ID, (Object)false);
    }

    protected void randomizeAttributes(RandomSource randomSource) {
        this.getAttribute(Attributes.JUMP_STRENGTH).setBaseValue(FallenMount.generateJumpStrength(() -> ((RandomSource)randomSource).nextDouble()));
    }

    public void tick() {
        if (!this.level().isClientSide && this.isAlive() && this.isConverting()) {
            --this.conversionTime;
            if (this.conversionTime <= 0) {
                this.finishConversion((ServerLevel)this.level());
            }
        }
        super.tick();
    }

    public boolean canEatGrass() {
        return false;
    }

    public boolean isSaddleable() {
        return false;
    }

    public void positionRider(Entity passenger, Entity.MoveFunction callback) {
        super.positionRider(passenger, callback);
        if (passenger instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)passenger;
            living.yBodyRot = this.yBodyRot;
            living.yHeadRot = this.yHeadRot;
            living.setYRot(this.getYRot());
            living.setXRot(this.getXRot());
        }
    }

    public boolean isPushable() {
        return this.isAlive() && !this.isSpectator() && !this.onClimbable();
    }

    public boolean isImmobile() {
        return this.isDeadOrDying();
    }

    public boolean isTamed() {
        return false;
    }

    public InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (itemStack.is(Items.GOLDEN_APPLE)) {
            if (this.hasEffect(MobEffects.WEAKNESS)) {
                if (!player.getAbilities().instabuild) {
                    itemStack.shrink(1);
                }
                if (!this.level().isClientSide) {
                    this.startConverting(player.getUUID(), this.random.nextInt(2400) + 3600);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void aiStep() {
        if (this.isAlive() && this.isSunBurnTick() && !this.isVehicle() && !this.isWearingBodyArmor()) {
            this.igniteForSeconds(8.0f);
        }
        super.aiStep();
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        ItemStack itemStack = new ItemStack((ItemLike)this.pickDefaultHorseArmor(random));
        this.setItemSlot(EquipmentSlot.BODY, itemStack);
        this.setDropChance(EquipmentSlot.BODY, 0.0f);
    }

    private Item pickDefaultHorseArmor(RandomSource random) {
        float randomValue = random.nextFloat();
        if (randomValue < 0.015f) {
            return Items.DIAMOND_HORSE_ARMOR;
        }
        if (randomValue < 0.05f) {
            return Items.GOLDEN_HORSE_ARMOR;
        }
        if (randomValue < 0.2f) {
            return Items.LEATHER_HORSE_ARMOR;
        }
        return Items.IRON_HORSE_ARMOR;
    }

    public boolean isSaddled() {
        return true;
    }

    public boolean canUseSlot(EquipmentSlot slot) {
        return true;
    }

    public boolean isBodyArmorItem(ItemStack itemStack) {
        AnimalArmorItem item;
        Item item2 = itemStack.getItem();
        return item2 instanceof AnimalArmorItem && (item = (AnimalArmorItem)item2).getBodyType() == AnimalArmorItem.BodyType.EQUESTRIAN;
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        if (this.horseData != null) {
            compoundTag.put(TAG_HORSE_DATA, (Tag)this.horseData);
        }
        compoundTag.putInt("ConversionTime", this.isConverting() ? this.conversionTime : -1);
        if (this.conversionStarter != null) {
            compoundTag.putUUID("ConversionPlayer", this.conversionStarter);
        }
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.horseData = compoundTag.getCompound(TAG_HORSE_DATA);
        if (compoundTag.contains("ConversionTime", 99) && compoundTag.getInt("ConversionTime") > -1) {
            this.startConverting(compoundTag.hasUUID("ConversionPlayer") ? compoundTag.getUUID("ConversionPlayer") : null, compoundTag.getInt("ConversionTime"));
        }
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.isConverting() && (this.horseData == null || !this.horseData.getBoolean("Tame"));
    }

    public boolean isConverting() {
        return (Boolean)this.getEntityData().get(DATA_CONVERTING_ID);
    }

    private void startConverting(@Nullable UUID conversionStarter, int conversionTime) {
        this.conversionStarter = conversionStarter;
        this.conversionTime = conversionTime;
        this.getEntityData().set(DATA_CONVERTING_ID, (Object)true);
        this.removeEffect(MobEffects.WEAKNESS);
        this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, conversionTime, Math.min(this.level().getDifficulty().getId() - 1, 0)));
        this.level().broadcastEntityEvent((Entity)this, (byte)16);
    }

    public void handleEntityEvent(byte id) {
        if (id == 16) {
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getEyeY(), this.getZ(), SoundEvents.ZOMBIE_VILLAGER_CURE, this.getSoundSource(), 1.0f + this.random.nextFloat(), this.random.nextFloat() * 0.7f + 0.3f, false);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    private void finishConversion(ServerLevel serverLevel) {
        this.recreateHorseFromData((Level)serverLevel, this).or(this::createFreshHorse).ifPresent(abstractHorse -> {
            abstractHorse.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
            if (!this.isSilent()) {
                this.level().levelEvent(null, 1027, this.blockPosition(), 0);
            }
            CommonAbstractions.INSTANCE.onLivingConvert((Mob)this, (Mob)abstractHorse);
        });
    }

    private Optional<AbstractHorse> recreateHorseFromData(Level level, FallenMount source) {
        CompoundTag tag = source.horseData;
        if (!level.isClientSide && tag != null && !tag.isEmpty()) {
            return EntityType.create((CompoundTag)tag, (Level)level).map(entity -> {
                AbstractHorse horse = (AbstractHorse)entity;
                horse.copyPosition((Entity)source);
                source.discard();
                level.addFreshEntity((Entity)horse);
                return horse;
            });
        }
        return Optional.empty();
    }

    private Optional<AbstractHorse> createFreshHorse() {
        EntityType entityType = this.random.nextInt(6) == 0 ? EntityType.DONKEY : EntityType.HORSE;
        AbstractHorse abstractHorse = (AbstractHorse)this.convertTo(entityType, false);
        for (EquipmentSlot equipmentSlot : this.dropPreservedEquipment(itemStack -> !EnchantmentHelper.has((ItemStack)itemStack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE))) {
            ItemStack itemStack2 = this.getItemBySlot(equipmentSlot);
            abstractHorse.setItemSlot(equipmentSlot, itemStack2);
        }
        abstractHorse.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(abstractHorse.blockPosition()), MobSpawnType.CONVERSION, (SpawnGroupData)new AgeableMob.AgeableMobGroupData(0.0f));
        abstractHorse.setTamed(true);
        if (this.conversionStarter != null) {
            abstractHorse.setOwnerUUID(this.conversionStarter);
        }
        abstractHorse.setBaby(false);
        return Optional.of(abstractHorse);
    }

    public boolean killedEntity(ServerLevel level, LivingEntity entity) {
        boolean killedEntity = super.killedEntity(level, entity);
        if ((level.getDifficulty() == Difficulty.NORMAL || level.getDifficulty() == Difficulty.HARD) && entity instanceof AbstractHorse) {
            AbstractHorse abstractHorse = (AbstractHorse)entity;
            if (CommonAbstractions.INSTANCE.canLivingConvert(entity, (EntityType<? extends LivingEntity>)((EntityType)ModEntityTypes.FALLEN_MOUNT_ENTITY_TYPE.value()), timer -> {})) {
                if (level.getDifficulty() != Difficulty.HARD && this.random.nextBoolean()) {
                    return killedEntity;
                }
                FallenMount fallenMount = (FallenMount)abstractHorse.convertTo((EntityType)ModEntityTypes.FALLEN_MOUNT_ENTITY_TYPE.value(), true);
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.putString("id", FallenMount.getEncodeId((Entity)abstractHorse));
                abstractHorse.setHealth(abstractHorse.getMaxHealth());
                abstractHorse.setDeltaMovement(Vec3.ZERO);
                abstractHorse.saveWithoutId(compoundTag);
                fallenMount.horseData = compoundTag;
                CommonAbstractions.INSTANCE.onLivingConvert((Mob)abstractHorse, (Mob)fallenMount);
                if (!this.isSilent()) {
                    level.levelEvent(null, 1026, this.blockPosition(), 0);
                }
                return false;
            }
        }
        return killedEntity;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        SpawnGroupData spawnGroupData = super.finalizeSpawn(level, difficulty, reason, spawnData);
        this.populateDefaultEquipmentSlots(level.getRandom(), difficulty);
        return spawnGroupData;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.ZOMBIE_HORSE_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ZOMBIE_HORSE_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.ZOMBIE_HORSE_HURT;
    }

    protected void playSwimSound(float volume) {
        if (this.onGround()) {
            super.playSwimSound(0.3f);
        } else {
            super.playSwimSound(Math.min(0.1f, volume * 25.0f));
        }
    }

    protected float getWaterSlowDown() {
        return 0.96f;
    }

    static class MountRestrictSunGoal
    extends RestrictSunGoal {
        private final PathfinderMob mob;

        public MountRestrictSunGoal(PathfinderMob pathfinderMob) {
            super(pathfinderMob);
            this.mob = pathfinderMob;
        }

        public boolean canUse() {
            return !this.mob.isVehicle() && super.canUse();
        }
    }

    static class MountFleeSunGoal
    extends FleeSunGoal {
        public MountFleeSunGoal(PathfinderMob pathfinderMob, double d) {
            super(pathfinderMob, d);
        }

        public boolean canUse() {
            return !this.mob.isVehicle() && super.canUse();
        }
    }
}

