/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.monster;

import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.sensing.Sensing;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface CompanionMob<T extends Mob> {
    public static final UniformInt ALERT_INTERVAL = TimeUtil.rangeOfSeconds((int)4, (int)6);

    public Mob getCompanionMob();

    @Nullable
    default public LivingEntity getCompanionTarget() {
        return this.getCompanionMob().getTarget();
    }

    public int getTicksUntilNextAlert();

    public void setTicksUntilNextAlert(int var1);

    default public void resetTicksUntilNextAlert() {
        this.setTicksUntilNextAlert(ALERT_INTERVAL.sample(this.getCompanionRandom()));
    }

    default public Level getCompanionLevel() {
        return this.getCompanionMob().level();
    }

    public Class<T> getCompanionType();

    default public Sensing getCompanionSensing() {
        return this.getCompanionMob().getSensing();
    }

    default public RandomSource getCompanionRandom() {
        return this.getCompanionMob().getRandom();
    }

    default public Vec3 getCompanionPosition() {
        return this.getCompanionMob().position();
    }

    default public double getCompanionAttributeValue(Holder<Attribute> attribute) {
        return this.getCompanionMob().getAttributeValue(attribute);
    }

    default public void maybeAlertCompanions() {
        if (this.getCompanionTarget() != null) {
            if (this.getTicksUntilNextAlert() > 0) {
                this.setTicksUntilNextAlert(this.getTicksUntilNextAlert() - 1);
            } else {
                if (this.getCompanionSensing().hasLineOfSight((Entity)this.getCompanionTarget())) {
                    this.alertCompanions();
                }
                this.resetTicksUntilNextAlert();
            }
        }
    }

    private void alertCompanions() {
        double followRange = this.getCompanionAttributeValue((Holder<Attribute>)Attributes.FOLLOW_RANGE);
        AABB aabb = AABB.unitCubeFromLowerCorner((Vec3)this.getCompanionPosition()).inflate(followRange, 10.0, followRange);
        for (Mob companion : this.getCompanionLevel().getEntitiesOfClass(this.getCompanionType(), aabb, EntitySelector.NO_SPECTATORS)) {
            if (companion.getTarget() != null || companion.isAlliedTo((Entity)this.getCompanionTarget())) continue;
            companion.setTarget(this.getCompanionTarget());
        }
    }
}

