/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.colors.data;

import com.benbenlaw.colors.block.ColorsBlocks;
import com.benbenlaw.colors.block.sets.PlankLikeBlocksList;
import com.benbenlaw.colors.block.sets.StoneLikeBlocksList;
import com.benbenlaw.colors.item.ColorsItems;
import com.benbenlaw.colors.util.ColorsTags;
import com.benbenlaw.core.util.ColorList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

public class ColorsRecipesBuilder
extends RecipeProvider {
    public ColorsRecipesBuilder(PackOutput output, CompletableFuture<HolderLookup.Provider> completableFuture) {
        super(output, completableFuture);
    }

    protected void buildRecipes(RecipeOutput consumer) {
        for (String color : ColorList.COLORS) {
            ItemLike slab;
            ItemLike stairs;
            String keyPrefix;
            String singularType;
            for (String type : StoneLikeBlocksList.STONE_BLOCKS) {
                singularType = type.endsWith("s") ? type.substring(0, type.length() - 1) : type;
                keyPrefix = color + "_" + singularType;
                if (type.equals("stone_bricks")) {
                    this.create2x2Recipe(consumer, (ItemLike)ColorsBlocks.STONE_BLOCKS.get(color + "_stone"), (ItemLike)ColorsBlocks.STONE_BLOCKS.get(color + "_stone_bricks"));
                }
                if (type.equals("asteroid")) {
                    this.create2x2Recipe(consumer, (ItemLike)ColorsBlocks.STONE_BLOCKS.get(color + "_asteroid"), (ItemLike)ColorsBlocks.STONE_BLOCKS.get(color + "_asteroid_bricks"));
                }
                if (type.equals("marble")) {
                    this.create2x2Recipe(consumer, (ItemLike)ColorsBlocks.STONE_BLOCKS.get(color + "_marble"), (ItemLike)ColorsBlocks.STONE_BLOCKS.get(color + "_marble_bricks"));
                }
                if (type.equals("cobblestone")) {
                    this.create2x2Recipe(consumer, (ItemLike)ColorsBlocks.STONE_BLOCKS.get(color + "_cobblestone"), (ItemLike)ColorsBlocks.STONE_BLOCKS.get(color + "_cobblestone_bricks"));
                }
                switch (type) {
                    case "prismarine": {
                        ColorsRecipesBuilder.stonecutterResultFromBase(consumer, (ItemLike)ColorsBlocks.STONE_BLOCKS.get(color + "_prismarine"), (ItemLike)Blocks.PRISMARINE, 1);
                        break;
                    }
                    case "prismarine_bricks": {
                        ColorsRecipesBuilder.stonecutterResultFromBase(consumer, (ItemLike)ColorsBlocks.STONE_BLOCKS.get(color + "_prismarine_bricks"), (ItemLike)Blocks.PRISMARINE_BRICKS, 1);
                        break;
                    }
                    case "dark_prismarine": {
                        ColorsRecipesBuilder.stonecutterResultFromBase(consumer, (ItemLike)ColorsBlocks.STONE_BLOCKS.get(color + "_dark_prismarine"), (ItemLike)Blocks.DARK_PRISMARINE, 1);
                        break;
                    }
                    default: {
                        ColorsRecipesBuilder.stonecutterResultFromBase(consumer, (ItemLike)ColorsBlocks.STONE_BLOCKS.get(color + "_" + type), (ItemLike)Blocks.STONE, 1);
                    }
                }
                ItemLike stone = (ItemLike)ColorsBlocks.STONE_BLOCKS.get(color + "_" + type);
                stairs = (ItemLike)ColorsBlocks.STONE_BLOCKS.get(keyPrefix + "_stairs");
                slab = (ItemLike)ColorsBlocks.STONE_BLOCKS.get(keyPrefix + "_slab");
                ItemLike wall = (ItemLike)ColorsBlocks.STONE_BLOCKS.get(keyPrefix + "_wall");
                ItemLike pressure_plate = (ItemLike)ColorsBlocks.STONE_BLOCKS.get(keyPrefix + "_pressure_plate");
                ItemLike button = (ItemLike)ColorsBlocks.STONE_BLOCKS.get(keyPrefix + "_button");
                this.createStoneLikeCraftingRecipes(consumer, stone, stairs, slab, wall, pressure_plate, button);
            }
            for (String type : PlankLikeBlocksList.PLANKS) {
                singularType = type.endsWith("s") ? type.substring(0, type.length() - 1) : type;
                keyPrefix = color + "_" + singularType;
                if (type.equals("bamboo_planks")) {
                    ColorsRecipesBuilder.stonecutterResultFromBase(consumer, (ItemLike)ColorsBlocks.PLANKS.get(color + "_" + type), (ItemLike)Blocks.BAMBOO_PLANKS, 1);
                } else if (type.equals("bamboo_mosaic")) {
                    ColorsRecipesBuilder.stonecutterResultFromBase(consumer, (ItemLike)ColorsBlocks.PLANKS.get(color + "_" + type), (ItemLike)Blocks.BAMBOO_MOSAIC, 1);
                } else {
                    ColorsRecipesBuilder.stonecutterResultFromBase(consumer, (ItemLike)ColorsBlocks.PLANKS.get(color + "_" + type), (ItemLike)Blocks.OAK_PLANKS, 1);
                }
                ItemLike plank = (ItemLike)ColorsBlocks.PLANKS.get(color + "_" + type);
                stairs = (ItemLike)ColorsBlocks.PLANKS.get(keyPrefix + "_stairs");
                slab = (ItemLike)ColorsBlocks.PLANKS.get(keyPrefix + "_slab");
                ItemLike fence = (ItemLike)ColorsBlocks.PLANKS.get(keyPrefix + "_fence");
                ItemLike fence_gate = (ItemLike)ColorsBlocks.PLANKS.get(keyPrefix + "_fence_gate");
                ItemLike pressure_plate = (ItemLike)ColorsBlocks.PLANKS.get(keyPrefix + "_pressure_plate");
                ItemLike button = (ItemLike)ColorsBlocks.PLANKS.get(keyPrefix + "_button");
                ItemLike trapdoor = (ItemLike)ColorsBlocks.PLANKS.get(keyPrefix + "_trapdoor");
                ItemLike door = (ItemLike)ColorsBlocks.PLANKS.get(keyPrefix + "_door");
                ItemLike sign = (ItemLike)ColorsItems.PLANKS.get(keyPrefix + "_sign");
                ItemLike hangingSign = (ItemLike)ColorsItems.PLANKS.get(keyPrefix + "_hanging_sign");
                this.createPlankLikeCraftingRecipes(consumer, plank, stairs, slab, fence, fence_gate, pressure_plate, button, trapdoor, door, sign, hangingSign);
            }
            ColorsRecipesBuilder.stonecutterResultFromBase(consumer, (ItemLike)ColorsBlocks.SAPLINGS.get(color + "_sapling"), (ItemLike)Items.OAK_SAPLING, 1);
            ColorsRecipesBuilder.stonecutterResultFromBase(consumer, (ItemLike)ColorsBlocks.GRASS_BLOCK.get(color + "_grass_block"), (ItemLike)Blocks.DIRT, 1);
            ColorsRecipesBuilder.stonecutterResultFromBase(consumer, (ItemLike)ColorsBlocks.GRASS_BLOCK.get(color + "_grass_block"), (ItemLike)Blocks.GRASS_BLOCK, 1);
            ColorsRecipesBuilder.stonecutterResultFromBase(consumer, (ItemLike)ColorsBlocks.DIRT.get(color + "_dirt"), (ItemLike)Blocks.DIRT, 1);
            ItemLike sprayCan = (ItemLike)ColorsItems.SPRAY_CANS.get(color + "_spray_can");
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)sprayCan, (int)1).pattern(" I ").pattern("IDI").pattern("IDI").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('D'), TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)("c:dyes/" + color)))).unlockedBy("has_item", ColorsRecipesBuilder.has((TagKey)Tags.Items.INGOTS_IRON)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("crafting/" + color + "_spray_can")));
            ItemLike craftingTable = (ItemLike)ColorsBlocks.CRAFTING_TABLE.get(color + "_crafting_table");
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)craftingTable, (int)1).pattern("SS").pattern("SS").define(Character.valueOf('S'), (ItemLike)ColorsBlocks.PLANKS.get(color + "_planks")).unlockedBy("has_item", ColorsRecipesBuilder.has((ItemLike)((ItemLike)ColorsBlocks.PLANKS.get(color + "_planks")))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("crafting/" + color + "_crafting_table")));
            ItemLike planks = (ItemLike)ColorsBlocks.PLANKS.get(color + "_planks");
            TagKey<Item> logTag = ColorsTags.Items.LOG_TAGS.get(color);
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)planks, (int)4).requires(logTag).unlockedBy("has_item", ColorsRecipesBuilder.has(logTag)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("crafting/" + color + "_planks_from_logs")));
            ItemLike wood = (ItemLike)ColorsBlocks.WOOD.get(color + "_wood");
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wood, (int)3).pattern("SS").pattern("SS").define(Character.valueOf('S'), (ItemLike)ColorsBlocks.LOGS.get(color + "_log")).unlockedBy("has_item", ColorsRecipesBuilder.has((ItemLike)((ItemLike)ColorsBlocks.LOGS.get(color + "_log")))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("crafting/" + color + "_wood")));
            ItemLike strippedWood = (ItemLike)ColorsBlocks.WOOD.get(color + "_stripped_wood");
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)strippedWood, (int)3).pattern("SS").pattern("SS").define(Character.valueOf('S'), (ItemLike)ColorsBlocks.LOGS.get(color + "_stripped_log")).unlockedBy("has_item", ColorsRecipesBuilder.has((ItemLike)((ItemLike)ColorsBlocks.LOGS.get(color + "_stripped_log")))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("crafting/" + color + "_stripped_wood")));
            ItemLike bambooPlanks = (ItemLike)ColorsBlocks.PLANKS.get(color + "_bamboo_planks");
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)bambooPlanks, (int)2).requires((ItemLike)ColorsBlocks.BAMBOO.get(color + "_bamboo")).unlockedBy("has_item", ColorsRecipesBuilder.has((ItemLike)((ItemLike)ColorsBlocks.BAMBOO.get(color + "_bamboo")))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("crafting/" + color + "_bamboo_planks_from_bamboo")));
            ItemLike dye = (ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)("minecraft:" + color + "_dye")));
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)dye, (int)1).requires((ItemLike)ColorsBlocks.POPPY.get(color + "_poppy")).unlockedBy("has_item", ColorsRecipesBuilder.has((ItemLike)((ItemLike)ColorsBlocks.POPPY.get(color + "_poppy")))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("crafting/" + color + "_dye_from_poppy")));
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)dye, (int)1).requires((ItemLike)ColorsBlocks.DANDELION.get(color + "_dandelion")).unlockedBy("has_item", ColorsRecipesBuilder.has((ItemLike)((ItemLike)ColorsBlocks.DANDELION.get(color + "_dandelion")))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("crafting/" + color + "_dye_from_dandelion")));
        }
        DeferredItem<Item> glowstoneSprayCan = ColorsItems.GLOWSTONE_SPRAY_CAN;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, glowstoneSprayCan, (int)1).pattern(" G ").pattern("GSG").pattern("GSG").define(Character.valueOf('G'), Tags.Items.DUSTS_GLOWSTONE).define(Character.valueOf('S'), Tags.Items.INGOTS_IRON).unlockedBy("has_item", ColorsRecipesBuilder.has((TagKey)Tags.Items.DUSTS_GLOWSTONE)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"colors", (String)"crafting/glowstone_spray_can"));
    }

    public void createPlankLikeCraftingRecipes(RecipeOutput consumer, ItemLike plank, ItemLike stairs, ItemLike slab, ItemLike fence, ItemLike fence_gate, ItemLike pressure_plate, ItemLike button, ItemLike trapdoor, ItemLike door, ItemLike sign, ItemLike hangingSign) {
        this.createStairsRecipe(consumer, plank, stairs);
        this.createSlabRecipe(consumer, plank, slab);
        this.createFenceRecipe(consumer, plank, fence);
        this.createFenceGateRecipe(consumer, plank, fence_gate);
        this.createPressurePlateRecipe(consumer, plank, pressure_plate);
        this.createButtonRecipe(consumer, plank, button);
        this.createTrapdoorRecipe(consumer, plank, trapdoor);
        this.createDoorRecipe(consumer, plank, door);
        this.createSignRecipe(consumer, plank, sign);
        this.createHangingSignRecipe(consumer, plank, hangingSign);
    }

    public void createStoneLikeCraftingRecipes(RecipeOutput consumer, ItemLike stone, ItemLike stairs, ItemLike slab, ItemLike wall, ItemLike pressure_plate, ItemLike button) {
        this.createStairsRecipe(consumer, stone, stairs);
        this.createSlabRecipe(consumer, stone, slab);
        this.createWallColoringRecipe(consumer, stone, wall);
        this.createPressurePlateRecipe(consumer, stone, pressure_plate);
        this.createButtonRecipe(consumer, stone, button);
        this.createStonecutterRecipes(consumer, stone, stairs, slab, wall, pressure_plate, button);
    }

    public void createHangingSignRecipe(RecipeOutput consumer, ItemLike input, ItemLike output) {
        String outputPath = BuiltInRegistries.ITEM.getKey((Object)output.asItem()).getPath();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output, (int)3).pattern("I I").pattern("SSS").pattern("SSS").define(Character.valueOf('S'), input).define(Character.valueOf('I'), (ItemLike)Items.CHAIN).unlockedBy("has_item", ColorsRecipesBuilder.has((ItemLike)input)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("crafting/" + outputPath)));
    }

    public void createSignRecipe(RecipeOutput consumer, ItemLike input, ItemLike output) {
        String outputPath = BuiltInRegistries.ITEM.getKey((Object)output.asItem()).getPath();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output, (int)3).pattern("SSS").pattern("SSS").pattern(" I ").define(Character.valueOf('S'), input).define(Character.valueOf('I'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", ColorsRecipesBuilder.has((ItemLike)input)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("crafting/" + outputPath)));
    }

    public void createFenceRecipe(RecipeOutput consumer, ItemLike input, ItemLike output) {
        String outputPath = BuiltInRegistries.ITEM.getKey((Object)output.asItem()).getPath();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)3).pattern("STS").pattern("STS").define(Character.valueOf('S'), input).define(Character.valueOf('T'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", ColorsRecipesBuilder.has((ItemLike)input)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("crafting/" + outputPath)));
    }

    public void createFenceGateRecipe(RecipeOutput consumer, ItemLike input, ItemLike output) {
        String outputPath = BuiltInRegistries.ITEM.getKey((Object)output.asItem()).getPath();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)1).pattern("WSW").pattern("WSW").define(Character.valueOf('S'), input).define(Character.valueOf('W'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", ColorsRecipesBuilder.has((ItemLike)input)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("crafting/" + outputPath)));
    }

    public void createTrapdoorRecipe(RecipeOutput consumer, ItemLike input, ItemLike output) {
        String outputPath = BuiltInRegistries.ITEM.getKey((Object)output.asItem()).getPath();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)2).pattern("SSS").pattern("SSS").define(Character.valueOf('S'), input).unlockedBy("has_item", ColorsRecipesBuilder.has((ItemLike)input)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("crafting/" + outputPath)));
    }

    public void createDoorRecipe(RecipeOutput consumer, ItemLike input, ItemLike output) {
        String outputPath = BuiltInRegistries.ITEM.getKey((Object)output.asItem()).getPath();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)3).pattern("SS").pattern("SS").pattern("SS").define(Character.valueOf('S'), input).unlockedBy("has_item", ColorsRecipesBuilder.has((ItemLike)input)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("crafting/" + outputPath)));
    }

    public void createStonecutterRecipes(RecipeOutput consumer, ItemLike stone, ItemLike stairs, ItemLike slab, ItemLike wall, ItemLike pressure_plate, ItemLike button) {
        ColorsRecipesBuilder.stonecutterResultFromBase(consumer, stairs, stone, 1);
        ColorsRecipesBuilder.stonecutterResultFromBase(consumer, slab, stone, 2);
        ColorsRecipesBuilder.stonecutterResultFromBase(consumer, wall, stone, 1);
        ColorsRecipesBuilder.stonecutterResultFromBase(consumer, pressure_plate, stone, 1);
        ColorsRecipesBuilder.stonecutterResultFromBase(consumer, button, stone, 1);
    }

    protected static void stonecutterResultFromBase(@NotNull RecipeOutput consumer, ItemLike itemLike, ItemLike itemLike1, int i) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemLike1}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)itemLike, (int)i).unlockedBy(ColorsRecipesBuilder.getHasName((ItemLike)itemLike1), ColorsRecipesBuilder.has((ItemLike)itemLike1)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("stonecutting/" + ColorsRecipesBuilder.getConversionRecipeName((ItemLike)itemLike, (ItemLike)itemLike1))));
    }

    public void createStairsRecipe(RecipeOutput consumer, ItemLike input, ItemLike output) {
        String outputPath = BuiltInRegistries.ITEM.getKey((Object)output.asItem()).getPath();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)4).pattern("S  ").pattern("SS ").pattern("SSS").define(Character.valueOf('S'), input).unlockedBy("has_item", ColorsRecipesBuilder.has((ItemLike)input)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("crafting/" + outputPath)));
    }

    public void createSlabRecipe(RecipeOutput consumer, ItemLike input, ItemLike output) {
        String outputPath = BuiltInRegistries.ITEM.getKey((Object)output.asItem()).getPath();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)6).pattern("SSS").define(Character.valueOf('S'), input).unlockedBy("has_item", ColorsRecipesBuilder.has((ItemLike)input)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("crafting/" + outputPath)));
    }

    public void createPressurePlateRecipe(RecipeOutput consumer, ItemLike input, ItemLike output) {
        String outputPath = BuiltInRegistries.ITEM.getKey((Object)output.asItem()).getPath();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)1).pattern("SS").define(Character.valueOf('S'), input).unlockedBy("has_item", ColorsRecipesBuilder.has((ItemLike)input)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("crafting/" + outputPath)));
    }

    public void createButtonRecipe(RecipeOutput consumer, ItemLike input, ItemLike output) {
        String outputPath = BuiltInRegistries.ITEM.getKey((Object)output.asItem()).getPath();
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output).requires(input).unlockedBy("has_item", ColorsRecipesBuilder.has((ItemLike)input)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("crafting/" + outputPath)));
    }

    public void createWallColoringRecipe(RecipeOutput consumer, ItemLike input, ItemLike output) {
        String outputPath = BuiltInRegistries.ITEM.getKey((Object)output.asItem()).getPath();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)6).pattern("SSS").pattern("SSS").define(Character.valueOf('S'), input).unlockedBy("has_item", ColorsRecipesBuilder.has((ItemLike)input)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("crafting/" + outputPath)));
    }

    public void create2x2Recipe(RecipeOutput consumer, ItemLike input, ItemLike output) {
        String outputPath = BuiltInRegistries.ITEM.getKey((Object)output.asItem()).getPath();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)4).pattern("SS").pattern("SS").define(Character.valueOf('S'), input).unlockedBy("has_item", ColorsRecipesBuilder.has((ItemLike)input)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("crafting/" + outputPath)));
    }
}

