/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.colors.block;

import com.benbenlaw.colors.block.sets.ColorsWoodTypes;
import com.benbenlaw.colors.block.sets.PlankLikeBlocksList;
import com.benbenlaw.colors.block.sets.StoneLikeBlocksList;
import com.benbenlaw.colors.item.ColorsItems;
import com.benbenlaw.colors.worldgen.ColorsConfiguredFeatures;
import com.benbenlaw.colors.worldgen.tree.ColorsTreeGrowers;
import com.benbenlaw.core.block.brightable.BrightBlock;
import com.benbenlaw.core.block.brightable.BrightCraftingTable;
import com.benbenlaw.core.block.brightable.BrightDoublePlantBlock;
import com.benbenlaw.core.block.brightable.BrightFlower;
import com.benbenlaw.core.block.brightable.BrightFlowerPot;
import com.benbenlaw.core.block.brightable.BrightGrassBlock;
import com.benbenlaw.core.block.brightable.BrightSapling;
import com.benbenlaw.core.block.brightable.BrightTallGrassBlock;
import com.benbenlaw.core.block.brightable.flammable.BrightFlammableLeaves;
import com.benbenlaw.core.block.brightable.flammable.BrightFlammableLog;
import com.benbenlaw.core.util.ColorList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ColorsBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"colors");
    public static final Map<String, DeferredBlock<Block>> STONE_BLOCKS = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> PLANKS = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> DIRT = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> GRASS_BLOCK = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> CRAFTING_TABLE = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> TALL_GRASS = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> SHORT_GRASS = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> DANDELION = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> POTTED_DANDELION = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> POPPY = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> POTTED_POPPY = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> LEAVES = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> LOGS = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> WOOD = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> BAMBOO = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> SAPLINGS = new HashMap<String, DeferredBlock<Block>>();

    public static void addPlanksToSigns(BlockEntityTypeAddBlocksEvent event) {
        for (String color : ColorList.COLORS) {
            event.modify(BlockEntityType.SIGN, new Block[]{(Block)PLANKS.get(color + "_plank_sign").get(), (Block)PLANKS.get(color + "_plank_wall_sign").get()});
            event.modify(BlockEntityType.HANGING_SIGN, new Block[]{(Block)PLANKS.get(color + "_plank_hanging_sign").get(), (Block)PLANKS.get(color + "_plank_wall_hanging_sign").get()});
            event.modify(BlockEntityType.SIGN, new Block[]{(Block)PLANKS.get(color + "_bamboo_plank_sign").get(), (Block)PLANKS.get(color + "_bamboo_plank_wall_sign").get()});
            event.modify(BlockEntityType.HANGING_SIGN, new Block[]{(Block)PLANKS.get(color + "_bamboo_plank_hanging_sign").get(), (Block)PLANKS.get(color + "_bamboo_plank_wall_hanging_sign").get()});
            event.modify(BlockEntityType.SIGN, new Block[]{(Block)PLANKS.get(color + "_bamboo_mosaic_sign").get(), (Block)PLANKS.get(color + "_bamboo_mosaic_wall_sign").get()});
            event.modify(BlockEntityType.HANGING_SIGN, new Block[]{(Block)PLANKS.get(color + "_bamboo_mosaic_hanging_sign").get(), (Block)PLANKS.get(color + "_bamboo_mosaic_wall_hanging_sign").get()});
        }
    }

    private static <T extends Block> DeferredBlock<T> registerBlockWithoutBlockItem(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ColorsBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ColorsItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static ToIntFunction<BlockState> litBlockEmission() {
        return blockState -> (Boolean)blockState.getValue((Property)BlockStateProperties.LIT) != false ? 15 : 0;
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }

    static {
        for (String color : ColorList.COLORS) {
            String keyPrefix;
            String singularType;
            SAPLINGS.put(color + "_sapling", ColorsBlocks.registerBlock(color + "_sapling", () -> new BrightSapling(ColorsTreeGrowers.TREE_GROWERS.get(color), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING).lightLevel(ColorsBlocks.litBlockEmission()))));
            BAMBOO.put(color + "_bamboo", ColorsBlocks.registerBlock(color + "_bamboo", () -> new BrightFlammableLog(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_BLOCK).lightLevel(ColorsBlocks.litBlockEmission()))));
            BAMBOO.put(color + "_stripped_bamboo", ColorsBlocks.registerBlock(color + "_stripped_bamboo", () -> new BrightFlammableLog(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_BLOCK).lightLevel(ColorsBlocks.litBlockEmission()))));
            LOGS.put(color + "_log", ColorsBlocks.registerBlock(color + "_log", () -> new BrightFlammableLog(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG).lightLevel(ColorsBlocks.litBlockEmission()))));
            LOGS.put(color + "_stripped_log", ColorsBlocks.registerBlock(color + "_stripped_log", () -> new BrightFlammableLog(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG).lightLevel(ColorsBlocks.litBlockEmission()))));
            WOOD.put(color + "_wood", ColorsBlocks.registerBlock(color + "_wood", () -> new BrightFlammableLog(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD).lightLevel(ColorsBlocks.litBlockEmission()))));
            WOOD.put(color + "_stripped_wood", ColorsBlocks.registerBlock(color + "_stripped_wood", () -> new BrightFlammableLog(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_WOOD).lightLevel(ColorsBlocks.litBlockEmission()))));
            LEAVES.put(color + "_leaves", ColorsBlocks.registerBlock(color + "_leaves", () -> new BrightFlammableLeaves(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).lightLevel(ColorsBlocks.litBlockEmission()))));
            TALL_GRASS.put(color + "_tall_grass", ColorsBlocks.registerBlock(color + "_tall_grass", () -> new BrightDoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_GRASS).lightLevel(ColorsBlocks.litBlockEmission()))));
            SHORT_GRASS.put(color + "_short_grass", ColorsBlocks.registerBlock(color + "_short_grass", () -> new BrightTallGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS).lightLevel(ColorsBlocks.litBlockEmission()), (BrightDoublePlantBlock)TALL_GRASS.get(color + "_tall_grass").get())));
            DANDELION.put(color + "_dandelion", ColorsBlocks.registerBlock(color + "_dandelion", () -> new BrightFlower(MobEffects.ABSORPTION, 0.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POPPY).sound(SoundType.GRASS).lightLevel(ColorsBlocks.litBlockEmission()).noOcclusion())));
            POTTED_DANDELION.put(color + "_potted_dandelion", ColorsBlocks.registerBlockWithoutBlockItem(color + "_potted_dandelion", () -> new BrightFlowerPot(() -> (FlowerPotBlock)Blocks.FLOWER_POT, (Supplier)DANDELION.get(color + "_dandelion"), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_DANDELION).lightLevel(ColorsBlocks.litBlockEmission()))));
            POPPY.put(color + "_poppy", ColorsBlocks.registerBlock(color + "_poppy", () -> new BrightFlower(MobEffects.ABSORPTION, 0.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POPPY).sound(SoundType.GRASS).lightLevel(ColorsBlocks.litBlockEmission()).noOcclusion())));
            POTTED_POPPY.put(color + "_potted_poppy", ColorsBlocks.registerBlockWithoutBlockItem(color + "_potted_poppy", () -> new BrightFlowerPot(() -> (FlowerPotBlock)Blocks.FLOWER_POT, (Supplier)POPPY.get(color + "_poppy"), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_POPPY).lightLevel(ColorsBlocks.litBlockEmission()))));
            DIRT.put(color + "_dirt", ColorsBlocks.registerBlock(color + "_dirt", () -> new BrightBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).lightLevel(ColorsBlocks.litBlockEmission()))));
            GRASS_BLOCK.put(color + "_grass_block", ColorsBlocks.registerBlock(color + "_grass_block", () -> new BrightGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRASS_BLOCK).lightLevel(ColorsBlocks.litBlockEmission()), ColorsConfiguredFeatures.GRASS_BONEMEAL_KEY.get(color), (Block)DIRT.get(color + "_dirt").get(), (Block)SHORT_GRASS.get(color + "_short_grass").get())));
            CRAFTING_TABLE.put(color + "_crafting_table", ColorsBlocks.registerBlock(color + "_crafting_table", () -> new BrightCraftingTable(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CRAFTING_TABLE).lightLevel(ColorsBlocks.litBlockEmission()))));
            for (String type : PlankLikeBlocksList.PLANKS) {
                singularType = type.endsWith("s") ? type.substring(0, type.length() - 1) : type;
                keyPrefix = color + "_" + singularType;
                PLANKS.put(color + "_" + type, ColorsBlocks.registerBlock(color + "_" + type, () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS))));
                PLANKS.put(keyPrefix + "_stairs", ColorsBlocks.registerBlock(keyPrefix + "_stairs", () -> {
                    BlockState baseState = ((Block)PLANKS.get(color + "_" + type).get()).defaultBlockState();
                    return new StairBlock(baseState, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_STAIRS));
                }));
                PLANKS.put(keyPrefix + "_slab", ColorsBlocks.registerBlock(keyPrefix + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SLAB))));
                PLANKS.put(keyPrefix + "_fence", ColorsBlocks.registerBlock(keyPrefix + "_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE))));
                PLANKS.put(keyPrefix + "_fence_gate", ColorsBlocks.registerBlock(keyPrefix + "_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE_GATE), SoundEvents.FENCE_GATE_OPEN, SoundEvents.FENCE_GATE_CLOSE)));
                PLANKS.put(keyPrefix + "_pressure_plate", ColorsBlocks.registerBlock(keyPrefix + "_pressure_plate", () -> new PressurePlateBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PRESSURE_PLATE))));
                PLANKS.put(keyPrefix + "_button", ColorsBlocks.registerBlock(keyPrefix + "_button", () -> new ButtonBlock(BlockSetType.OAK, 30, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_BUTTON))));
                PLANKS.put(keyPrefix + "_trapdoor", ColorsBlocks.registerBlock(keyPrefix + "_trapdoor", () -> new TrapDoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR))));
                PLANKS.put(keyPrefix + "_door", ColorsBlocks.registerBlock(keyPrefix + "_door", () -> new DoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR))));
                System.out.println("woodtyp2 " + String.valueOf(ColorsWoodTypes.getWoodType(color, singularType)));
                PLANKS.put(keyPrefix + "_sign", ColorsBlocks.registerBlockWithoutBlockItem(keyPrefix + "_sign", () -> new StandingSignBlock(ColorsWoodTypes.getWoodType(color, singularType), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SIGN))));
                PLANKS.put(keyPrefix + "_wall_sign", ColorsBlocks.registerBlockWithoutBlockItem(keyPrefix + "_wall_sign", () -> new WallSignBlock(ColorsWoodTypes.getWoodType(color, singularType), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_SIGN))));
                PLANKS.put(keyPrefix + "_hanging_sign", ColorsBlocks.registerBlockWithoutBlockItem(keyPrefix + "_hanging_sign", () -> new CeilingHangingSignBlock(ColorsWoodTypes.getWoodType(color, singularType), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_HANGING_SIGN))));
                PLANKS.put(keyPrefix + "_wall_hanging_sign", ColorsBlocks.registerBlockWithoutBlockItem(keyPrefix + "_wall_hanging_sign", () -> new WallHangingSignBlock(ColorsWoodTypes.getWoodType(color, singularType), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_HANGING_SIGN))));
            }
            for (String type : StoneLikeBlocksList.STONE_BLOCKS) {
                singularType = type.endsWith("s") ? type.substring(0, type.length() - 1) : type;
                keyPrefix = color + "_" + singularType;
                STONE_BLOCKS.put(color + "_" + type, ColorsBlocks.registerBlock(color + "_" + type, () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE))));
                STONE_BLOCKS.put(keyPrefix + "_stairs", ColorsBlocks.registerBlock(keyPrefix + "_stairs", () -> {
                    BlockState baseState = ((Block)STONE_BLOCKS.get(color + "_" + type).get()).defaultBlockState();
                    return new StairBlock(baseState, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_STAIRS));
                }));
                STONE_BLOCKS.put(keyPrefix + "_slab", ColorsBlocks.registerBlock(keyPrefix + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_SLAB))));
                STONE_BLOCKS.put(keyPrefix + "_wall", ColorsBlocks.registerBlock(keyPrefix + "_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE_WALL))));
                STONE_BLOCKS.put(keyPrefix + "_pressure_plate", ColorsBlocks.registerBlock(keyPrefix + "_pressure_plate", () -> new PressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_PRESSURE_PLATE))));
                STONE_BLOCKS.put(keyPrefix + "_button", ColorsBlocks.registerBlock(keyPrefix + "_button", () -> new ButtonBlock(BlockSetType.STONE, 20, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BUTTON))));
            }
        }
    }
}

