/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.common.nodes;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ItemNode
implements IDataNode,
IItemNode {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"ali", (String)"item");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final StreamCodec<RegistryFriendlyByteBuf, TagKey<Item>> ITEM_TAG_STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries((Codec)TagKey.codec((ResourceKey)Registries.ITEM));
    private static final StreamCodec<RegistryFriendlyByteBuf, TagKey<Block>> BLOCK_TAG_STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries((Codec)TagKey.codec((ResourceKey)Registries.BLOCK));
    private static final StreamCodec<RegistryFriendlyByteBuf, TagKey<? extends ItemLike>> ITEM_LIKE_TAG_CODEC = new StreamCodec<RegistryFriendlyByteBuf, TagKey<? extends ItemLike>>(){

        @NotNull
        public TagKey<? extends ItemLike> decode(RegistryFriendlyByteBuf buf) {
            boolean isItem = buf.readBoolean();
            if (isItem) {
                return (TagKey)ITEM_TAG_STREAM_CODEC.decode((Object)buf);
            }
            return (TagKey)BLOCK_TAG_STREAM_CODEC.decode((Object)buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, TagKey<? extends ItemLike> tag) {
            if (tag.registry().equals(Registries.ITEM)) {
                buf.writeBoolean(true);
                ITEM_TAG_STREAM_CODEC.encode((Object)buf, tag);
            } else if (tag.registry().equals(Registries.BLOCK)) {
                buf.writeBoolean(false);
                BLOCK_TAG_STREAM_CODEC.encode((Object)buf, tag);
            } else {
                throw new IllegalArgumentException("Unsupported TagKey registry: " + String.valueOf(tag.registry()));
            }
        }
    };
    private static final StreamCodec<RegistryFriendlyByteBuf, Either<ItemStack, TagKey<? extends ItemLike>>> EITHER_CODEC = ByteBufCodecs.either((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, ITEM_LIKE_TAG_CODEC);
    private final ITooltipNode tooltip;
    private final List<LootItemCondition> conditions;
    private final List<LootItemFunction> functions;
    private final Either<ItemStack, TagKey<? extends ItemLike>> item;
    private final RangeValue count;
    private final float chance;

    public ItemNode(float chance, RangeValue count, ItemStack item, ITooltipNode tooltip, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        this(chance, count, (Either<ItemStack, TagKey<? extends ItemLike>>)Either.left((Object)item), tooltip, functions, conditions);
    }

    public ItemNode(float chance, RangeValue count, TagKey<? extends ItemLike> tag, ITooltipNode tooltip, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        this(chance, count, (Either<ItemStack, TagKey<? extends ItemLike>>)Either.right(tag), tooltip, functions, conditions);
    }

    public ItemNode(float chance, RangeValue count, Either<ItemStack, TagKey<? extends ItemLike>> item, ITooltipNode tooltip, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        this.chance = chance;
        this.count = count;
        this.item = item;
        this.tooltip = tooltip;
        this.functions = functions;
        this.conditions = conditions;
    }

    public ItemNode(IClientUtils utils, RegistryFriendlyByteBuf buf) {
        this.item = (Either)EITHER_CODEC.decode((Object)buf);
        this.tooltip = ITooltipNode.decodeNode(utils, buf);
        this.count = new RangeValue((FriendlyByteBuf)buf);
        this.chance = buf.readFloat();
        this.conditions = Collections.emptyList();
        this.functions = Collections.emptyList();
    }

    @Override
    public Either<ItemStack, TagKey<? extends ItemLike>> getModifiedItem() {
        return this.item;
    }

    @Override
    public List<LootItemCondition> getConditions() {
        return this.conditions;
    }

    @Override
    public List<LootItemFunction> getFunctions() {
        return this.functions;
    }

    @Override
    public RangeValue getCount() {
        return this.count;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    @Override
    public void encode(IServerUtils utils, RegistryFriendlyByteBuf buf) {
        int index = buf.writerIndex();
        try {
            EITHER_CODEC.encode((Object)buf, this.item);
        }
        catch (Throwable e) {
            buf.writerIndex(index);
            EITHER_CODEC.encode((Object)buf, (Object)Either.left((Object)ItemStack.EMPTY));
            LOGGER.warn("Failed to encode {}/{}", new Object[]{BuiltInRegistries.ITEM.getKey((Object)this.item.left().map(ItemStack::getItem).orElse(Items.AIR)), this.item.right().orElse(null), e});
        }
        ITooltipNode.encodeNode(utils, this.tooltip, buf);
        this.count.encode((FriendlyByteBuf)buf);
        buf.writeFloat(this.chance);
    }

    @Override
    public ITooltipNode getTooltip() {
        return this.tooltip;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

