/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.neoforge.plugin;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.AliEntrypoint;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IOperation;
import com.yanny.ali.api.IPlugin;
import com.yanny.ali.api.IServerRegistry;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.neoforge.mixin.MixinAddTableLootModifier;
import com.yanny.ali.neoforge.mixin.MixinCanItemPerformAbility;
import com.yanny.ali.neoforge.mixin.MixinLootModifier;
import com.yanny.ali.neoforge.mixin.MixinLootTableIdCondition;
import com.yanny.ali.neoforge.mixin.MixinNeoForgeEventHandler;
import com.yanny.ali.neoforge.plugin.IForgePlugin;
import com.yanny.ali.platform.Services;
import com.yanny.ali.plugin.common.NodeUtils;
import com.yanny.ali.plugin.common.nodes.ReferenceNode;
import com.yanny.ali.plugin.common.tooltip.ArrayTooltipNode;
import com.yanny.ali.plugin.common.tooltip.LiteralTooltipNode;
import com.yanny.ali.plugin.glm.GlobalLootModifierUtils;
import com.yanny.ali.plugin.glm.IGlobalLootModifierPlugin;
import com.yanny.ali.plugin.glm.IGlobalLootModifierWrapper;
import com.yanny.ali.plugin.glm.ILootTableIdConditionPredicate;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.AddTableLootModifier;
import net.neoforged.neoforge.common.loot.CanItemPerformAbility;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.neoforged.neoforge.common.loot.LootModifierManager;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.slf4j.Logger;

@AliEntrypoint
public class NeoForgePlugin
implements IPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public String getModId() {
        return "neoforge";
    }

    @Override
    public void registerServer(IServerRegistry registry) {
        registry.registerConditionTooltip(CanItemPerformAbility.class, NeoForgePlugin::getCanToolPerformActionTooltip);
        registry.registerConditionTooltip(LootTableIdCondition.class, NeoForgePlugin::getLootTableIdTooltip);
        registry.registerLootModifiers(NeoForgePlugin::registerLootModifiers);
    }

    public static @Unmodifiable @NotNull ITooltipNode getCanToolPerformActionTooltip(IServerUtils utils, CanItemPerformAbility condition) {
        MixinCanItemPerformAbility cond = (MixinCanItemPerformAbility)condition;
        return utils.getValueTooltip(utils, cond.getAbility()).build("ali.type.condition.can_item_perform_ability");
    }

    public static @Unmodifiable @NotNull ITooltipNode getLootTableIdTooltip(IServerUtils utils, LootTableIdCondition condition) {
        MixinLootTableIdCondition cond = (MixinLootTableIdCondition)condition;
        return utils.getValueTooltip(utils, cond.getTargetLootTableId()).build("ali.type.condition.loot_table_id");
    }

    @NotNull
    private static List<ILootModifier<?>> registerLootModifiers(IServerUtils utils) {
        HashMap glmMap = new HashMap();
        HashSet<Class> missingGLM = new HashSet<Class>();
        ArrayList lootModifiers = new ArrayList();
        ILootTableIdConditionPredicate tablePredicate = NeoForgePlugin.getLootTableIdConditionPredicate();
        IGlobalLootModifierPlugin.IRegistry forgeRegistry = NeoForgePlugin.getForgeRegistry(glmMap);
        for (IPlugin plugin : Services.getPlatform().getPlugins()) {
            if (!(plugin instanceof IForgePlugin)) continue;
            IForgePlugin forgePlugin = (IForgePlugin)plugin;
            forgePlugin.registerGlobalLootModifier(forgeRegistry, tablePredicate);
        }
        LootModifierManager lootModifierManager = MixinNeoForgeEventHandler.getLootModifierManager();
        forgeRegistry.registerGlobalLootModifier(AddTableLootModifier.class, (u, m) -> {
            List<LootItemCondition> conditionList = Arrays.asList(((MixinLootModifier)m).getConditions());
            return GlobalLootModifierUtils.getLootModifier(conditionList, c -> {
                ArrayTooltipNode tooltip = ArrayTooltipNode.array().add(LiteralTooltipNode.translatable("ali.enum.group_type.all")).add(GenericTooltipUtils.getConditionsTooltip(utils, c)).build();
                ReferenceNode node = NodeUtils.getReferenceNode(utils, ((MixinAddTableLootModifier)m).getTable().location(), c, tooltip);
                return List.of(new IOperation.AddOperation(i -> true, node));
            }, tablePredicate);
        });
        for (IGlobalLootModifier globalLootModifier : lootModifierManager.getAllLootMods()) {
            IGlobalLootModifierWrapper wrapper = NeoForgePlugin.wrap(globalLootModifier);
            try {
                BiFunction getter = (BiFunction)glmMap.get(globalLootModifier.getClass());
                if (getter != null) {
                    Optional lootModifier = (Optional)getter.apply(utils, globalLootModifier);
                    if (lootModifier.isPresent()) {
                        lootModifiers.add((ILootModifier)lootModifier.get());
                        continue;
                    }
                    LOGGER.warn("Unable to locate destination for GLM {}", (Object)wrapper.getName());
                    continue;
                }
                Optional<ILootModifier<?>> modifier = GlobalLootModifierUtils.getMissingGlobalLootModifier(utils, wrapper, tablePredicate);
                missingGLM.add(globalLootModifier.getClass());
                if (modifier.isPresent()) {
                    lootModifiers.add(modifier.get());
                    continue;
                }
                LOGGER.warn("Unable to locate destination for auto GLM {}", (Object)wrapper.getName());
            }
            catch (Throwable e) {
                e.printStackTrace();
                LOGGER.warn("Failed to add GLM with error {}", (Object)e.getMessage());
            }
        }
        missingGLM.forEach(c -> LOGGER.warn("Missing GLM for {}", (Object)c.getName()));
        return lootModifiers;
    }

    @NotNull
    private static ILootTableIdConditionPredicate getLootTableIdConditionPredicate() {
        return new ILootTableIdConditionPredicate(){

            @Override
            public boolean isLootTableIdCondition(LootItemCondition condition) {
                return condition instanceof LootTableIdCondition;
            }

            @Override
            public ResourceLocation getTargetLootTableId(LootItemCondition condition) {
                return ((MixinLootTableIdCondition)condition).getTargetLootTableId();
            }
        };
    }

    @NotNull
    private static IGlobalLootModifierWrapper wrap(final IGlobalLootModifier modifier) {
        return new IGlobalLootModifierWrapper(){

            @Override
            public ResourceLocation getName() {
                return NeoForgeRegistries.GLOBAL_LOOT_MODIFIER_SERIALIZERS.getKey((Object)modifier.codec());
            }

            @Override
            public Class<?> getLootModifierClass() {
                return LootModifier.class;
            }

            @Override
            public boolean isLootModifier() {
                return modifier instanceof LootModifier;
            }

            @Override
            public List<LootItemCondition> getConditions() {
                return Arrays.asList(((MixinLootModifier)modifier).getConditions());
            }
        };
    }

    @NotNull
    private static IGlobalLootModifierPlugin.IRegistry getForgeRegistry(final Map<Class<?>, BiFunction<IServerUtils, IGlobalLootModifier, Optional<ILootModifier<?>>>> glmMap) {
        return new IGlobalLootModifierPlugin.IRegistry(){

            @Override
            public <T> void registerGlobalLootModifier(Class<T> type, BiFunction<IServerUtils, T, Optional<ILootModifier<?>>> getter) {
                glmMap.put(type, (u, t) -> (Optional)getter.apply((IServerUtils)u, (Object)t));
            }
        };
    }
}

