/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.lootjs;

import com.almostreliable.lootjs.core.filters.IdFilter;
import com.almostreliable.lootjs.core.filters.ItemFilter;
import com.almostreliable.lootjs.loot.condition.CustomParamPredicate;
import com.almostreliable.lootjs.loot.condition.IsLightLevel;
import com.almostreliable.lootjs.loot.condition.MatchAnyInventorySlot;
import com.almostreliable.lootjs.loot.condition.MatchBiome;
import com.almostreliable.lootjs.loot.condition.MatchDimension;
import com.almostreliable.lootjs.loot.condition.MatchEquipmentSlot;
import com.almostreliable.lootjs.loot.condition.MatchKillerDistance;
import com.almostreliable.lootjs.loot.condition.MatchPlayer;
import com.almostreliable.lootjs.loot.condition.MatchStructure;
import com.almostreliable.lootjs.loot.condition.PlayerParamPredicate;
import com.almostreliable.lootjs.loot.modifier.LootModifier;
import com.mojang.logging.LogUtils;
import com.yanny.ali.api.AliEntrypoint;
import com.yanny.ali.api.IClientRegistry;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IPlugin;
import com.yanny.ali.api.IServerRegistry;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.lootjs.BlockLootModifier;
import com.yanny.ali.lootjs.EntityLootModifier;
import com.yanny.ali.lootjs.TableLootModifier;
import com.yanny.ali.lootjs.mixin.MixinLootModificationsAPI;
import com.yanny.ali.lootjs.modifier.CustomPlayerFunction;
import com.yanny.ali.lootjs.modifier.ModifiedItemFunction;
import com.yanny.ali.lootjs.node.ItemStackNode;
import com.yanny.ali.lootjs.node.ItemTagNode;
import com.yanny.ali.lootjs.server.LootJsConditionTooltipUtils;
import com.yanny.ali.lootjs.server.LootJsFunctionTooltipUtils;
import com.yanny.ali.lootjs.server.LootJsGenericTooltipUtils;
import com.yanny.ali.lootjs.widget.ItemStackWidget;
import com.yanny.ali.lootjs.widget.ItemTagWidget;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@AliEntrypoint
public class LootJsPlugin
implements IPlugin {
    public static final String ID = "lootjs";
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public String getModId() {
        return ID;
    }

    @NotNull
    public static List<ILootModifier<?>> registerModifiers(IServerUtils utils) {
        ArrayList modifiers = new ArrayList();
        List<LootModifier> actions = MixinLootModificationsAPI.getModifiers();
        for (LootModifier action : actions) {
            Predicate predicate = action.runPredicate();
            try {
                Predicate predicate2 = predicate;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LootModifier.BlockFiltered.class, LootModifier.EntityFiltered.class, LootModifier.TableFiltered.class, LootModifier.TypeFiltered.class}, (Object)predicate2, n)) {
                    case 0: {
                        LootModifier.BlockFiltered blockFiltered = (LootModifier.BlockFiltered)predicate2;
                        modifiers.add(new BlockLootModifier(utils, action, blockFiltered));
                        break;
                    }
                    case 1: {
                        LootModifier.EntityFiltered entityFiltered = (LootModifier.EntityFiltered)predicate2;
                        modifiers.add(new EntityLootModifier(utils, action, entityFiltered));
                        break;
                    }
                    case 2: {
                        LootModifier.TableFiltered tableFiltered = (LootModifier.TableFiltered)predicate2;
                        modifiers.add(new TableLootModifier(utils, action, tableFiltered));
                        break;
                    }
                    case 3: {
                        LootModifier.TypeFiltered typeFiltered = (LootModifier.TypeFiltered)predicate2;
                        modifiers.add(new TableLootModifier(utils, action, typeFiltered));
                        break;
                    }
                    default: {
                        LOGGER.error("Skipping unexpected modification type {}", (Object)actions.getClass().getCanonicalName());
                        break;
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                LOGGER.error("Failed to process loot modification {}: {}", (Object)action.name(), (Object)e.getMessage());
            }
        }
        return modifiers;
    }

    @Override
    public void registerClient(IClientRegistry registry) {
        registry.registerDataNode(ItemStackNode.ID, ItemStackNode::new);
        registry.registerDataNode(ItemTagNode.ID, ItemTagNode::new);
        registry.registerWidget(ItemStackNode.ID, ItemStackWidget::new);
        registry.registerWidget(ItemTagNode.ID, ItemTagWidget::new);
    }

    @Override
    public void registerServer(IServerRegistry registry) {
        registry.registerConditionTooltip(MatchBiome.class, LootJsConditionTooltipUtils::matchBiomeTooltip);
        registry.registerConditionTooltip(MatchDimension.class, LootJsConditionTooltipUtils::matchDimensionTooltip);
        registry.registerConditionTooltip(MatchStructure.class, LootJsConditionTooltipUtils::matchStructureTooltip);
        registry.registerConditionTooltip(CustomParamPredicate.class, LootJsConditionTooltipUtils::customParamPredicateTooltip);
        registry.registerConditionTooltip(IsLightLevel.class, LootJsConditionTooltipUtils::isLightLevelTooltip);
        registry.registerConditionTooltip(MatchEquipmentSlot.class, LootJsConditionTooltipUtils::getMatchEquipmentSlotTooltip);
        registry.registerConditionTooltip(MatchKillerDistance.class, LootJsConditionTooltipUtils::matchKillerDistanceTooltip);
        registry.registerConditionTooltip(MatchPlayer.class, LootJsConditionTooltipUtils::matchPlayerTooltip);
        registry.registerConditionTooltip(PlayerParamPredicate.class, LootJsConditionTooltipUtils::playerParamPredicateTooltip);
        registry.registerConditionTooltip(MatchAnyInventorySlot.class, LootJsConditionTooltipUtils::matchAnyInventorySlot);
        registry.registerFunctionTooltip(CustomPlayerFunction.class, LootJsFunctionTooltipUtils::customPlayerTooltip);
        registry.registerFunctionTooltip(ModifiedItemFunction.class, LootJsFunctionTooltipUtils::modifiedItemTooltip);
        registry.registerValueTooltip(ItemFilter.class, LootJsGenericTooltipUtils::getItemFilterTooltip);
        registry.registerValueTooltip(IdFilter.class, LootJsGenericTooltipUtils::getIdFilterTooltip);
        registry.registerValueTooltip(ItemAbility.class, LootJsGenericTooltipUtils::getItemAbilityTooltip);
        registry.registerLootModifiers(LootJsPlugin::registerModifiers);
    }
}

