/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.lootjs;

import com.almostreliable.lootjs.core.entry.ItemLootEntry;
import com.almostreliable.lootjs.core.filters.ItemFilter;
import com.almostreliable.lootjs.loot.modifier.LootAction;
import com.almostreliable.lootjs.loot.modifier.LootModifier;
import com.almostreliable.lootjs.loot.modifier.handler.AddLootAction;
import com.almostreliable.lootjs.loot.modifier.handler.ModifyLootAction;
import com.almostreliable.lootjs.loot.modifier.handler.RemoveLootAction;
import com.almostreliable.lootjs.loot.modifier.handler.ReplaceLootAction;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IItemNode;
import com.yanny.ali.api.ILootModifier;
import com.yanny.ali.api.IOperation;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.lootjs.modifier.ModifiedItemFunction;
import com.yanny.ali.lootjs.node.ItemStackNode;
import com.yanny.ali.lootjs.node.ItemTagNode;
import com.yanny.ali.plugin.common.NodeUtils;
import com.yanny.ali.plugin.common.nodes.ModifiedNode;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public abstract class AbstractLootModifier<T>
implements ILootModifier<T> {
    protected static final Logger LOGGER = LogUtils.getLogger();
    private final List<IOperation> operations = new ArrayList<IOperation>();

    public AbstractLootModifier(IServerUtils utils, LootModifier modifier) {
        List conditions = modifier.conditions();
        List functions = modifier.functions();
        List actions = modifier.actions();
        block6: for (LootAction action : actions) {
            LootAction lootAction;
            Objects.requireNonNull(action);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AddLootAction.class, RemoveLootAction.class, ReplaceLootAction.class, ModifyLootAction.class}, (Object)lootAction, n)) {
                case 0: {
                    AddLootAction addLootAction = (AddLootAction)lootAction;
                    for (LootPoolEntryContainer entry : addLootAction.entries()) {
                        this.operations.add(new IOperation.AddOperation(s -> true, utils.getEntryFactory(utils, entry).create(utils, entry, 1.0f, 1, functions, conditions)));
                    }
                    continue block6;
                }
                case 1: {
                    RemoveLootAction removeLootAction = (RemoveLootAction)lootAction;
                    this.operations.add(new IOperation.RemoveOperation(arg_0 -> ((ItemFilter)removeLootAction.filter()).test(arg_0)));
                    break;
                }
                case 2: {
                    ReplaceLootAction replaceLootAction = (ReplaceLootAction)lootAction;
                    Function<IDataNode, List<IDataNode>> factory = c -> {
                        ArrayList<IDataNode> nodes = new ArrayList<IDataNode>();
                        IItemNode node = (IItemNode)((Object)c);
                        ItemLootEntry entry = replaceLootAction.itemLootEntry();
                        boolean preserveCount = replaceLootAction.preserveCount();
                        List<LootItemCondition> allConditions = Stream.concat(conditions.stream(), node.getConditions().stream()).toList();
                        List<LootItemFunction> allFunctions = Stream.concat(functions.stream(), node.getFunctions().stream()).toList();
                        if (!conditions.isEmpty()) {
                            nodes.add(new ModifiedNode(utils, (IDataNode)c, NodeUtils.getItemNode(utils, (LootItem)entry.getVanillaEntry(), 1.0f, 1, allFunctions, allConditions)));
                        } else {
                            nodes.add(NodeUtils.getItemNode(utils, (LootItem)entry.getVanillaEntry(), 1.0f, 1, allFunctions, allConditions));
                        }
                        return nodes;
                    };
                    this.operations.add(new IOperation.ReplaceOperation(arg_0 -> ((ItemFilter)replaceLootAction.filter()).test(arg_0), factory));
                    break;
                }
                case 3: {
                    ModifyLootAction modifyLootAction = (ModifyLootAction)lootAction;
                    Function<IDataNode, List<IDataNode>> factory = c -> {
                        ArrayList<IDataNode> nodes = new ArrayList<IDataNode>();
                        IItemNode node = (IItemNode)((Object)c);
                        List<LootItemCondition> allConditions = Stream.concat(conditions.stream(), node.getConditions().stream()).toList();
                        ArrayList<LootItemFunction> allFunctions = new ArrayList<LootItemFunction>();
                        Either<ItemStack, TagKey<? extends ItemLike>> either = node.getModifiedItem();
                        allFunctions.add(new ModifiedItemFunction());
                        allFunctions.addAll(Stream.concat(functions.stream(), node.getFunctions().stream()).toList());
                        if (!conditions.isEmpty()) {
                            nodes.add(new ModifiedNode(utils, (IDataNode)c, AbstractLootModifier.constructEither(utils, either, node.getChance(), allFunctions, allConditions)));
                        } else {
                            nodes.add(AbstractLootModifier.constructEither(utils, either, node.getChance(), allFunctions, allConditions));
                        }
                        return nodes;
                    };
                    this.operations.add(new IOperation.ReplaceOperation(arg_0 -> ((ItemFilter)modifyLootAction.predicate()).test(arg_0), factory));
                    break;
                }
                default: {
                    LOGGER.warn("Skipping unexpected loot action {}", (Object)action.getClass().getCanonicalName());
                }
            }
        }
    }

    @Override
    public List<IOperation> getOperations() {
        return this.operations;
    }

    private static IDataNode constructEither(IServerUtils utils, Either<ItemStack, TagKey<? extends ItemLike>> either, float chance, List<LootItemFunction> functions, List<LootItemCondition> conditions) {
        return (IDataNode)either.map(itemStack -> new ItemStackNode(utils, (ItemStack)itemStack, chance, true, functions, conditions, true), tagKey -> new ItemTagNode(utils, (TagKey<? extends ItemLike>)tagKey, chance, true, functions, conditions, true));
    }
}

