/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.jei.compatibility.jei;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.yanny.ali.api.Rect;
import com.yanny.ali.plugin.client.WidgetUtils;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.api.gui.inputs.RecipeSlotUnderMouse;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.gui.widgets.ISlottedRecipeWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class JeiScrollWidget
implements IRecipeWidget,
IJeiInputHandler,
ISlottedRecipeWidget {
    private static final int SCROLLBAR_PADDING = 2;
    private static final int SCROLLBAR_WIDTH = 8;
    private static final int MIN_SCROLL_MARKER_HEIGHT = 14;
    private static final int SCROLL_RATE = 8;
    private final Rect rect;
    private final Rect contentRect;
    private final Rect scrollRect;
    private final List<IRecipeWidget> widgets;
    private double dragOriginY = -1.0;
    private float scrollOffsetY = 0.0f;

    public JeiScrollWidget(Rect rect, int contentHeight, List<IRecipeWidget> widgets) {
        this.rect = rect;
        this.widgets = widgets;
        this.contentRect = new Rect(0, 0, rect.width() - JeiScrollWidget.getScrollBoxScrollbarExtraWidth(), contentHeight);
        this.scrollRect = JeiScrollWidget.calculateScrollArea(rect.width(), rect.height());
    }

    @NotNull
    public ScreenRectangle getArea() {
        return new ScreenRectangle(this.rect.x(), this.rect.y(), this.rect.width(), this.rect.height());
    }

    @NotNull
    public ScreenPosition getPosition() {
        return new ScreenPosition(this.rect.x(), this.rect.y());
    }

    @NotNull
    public Optional<RecipeSlotUnderMouse> getSlotUnderMouse(double mouseX, double mouseY) {
        float scrollAmount = (float)this.getHiddenAmount() * this.scrollOffsetY;
        for (IRecipeWidget widget : this.widgets) {
            ISlottedRecipeWidget slottedWidget;
            Optional slotUnderMouse;
            if (!(widget instanceof ISlottedRecipeWidget) || !(slotUnderMouse = (slottedWidget = (ISlottedRecipeWidget)widget).getSlotUnderMouse(mouseX, mouseY + (double)scrollAmount)).isPresent()) continue;
            return Optional.of(new RecipeSlotUnderMouse(((RecipeSlotUnderMouse)slotUnderMouse.get()).slot(), 1, (int)(1.0f - scrollAmount)));
        }
        return Optional.empty();
    }

    public void drawWidget(GuiGraphics guiGraphics, double mouseX, double mouseY) {
        WidgetUtils.blitNineSliced(guiGraphics, WidgetUtils.TEXTURE_LOC, this.scrollRect.x(), this.scrollRect.y(), this.scrollRect.width(), this.scrollRect.height(), 2, 2, 2, 2, 16, 16, 2, 2);
        Rect markerArea = this.calculateScrollbarMarkerArea();
        WidgetUtils.blitNineSliced(guiGraphics, WidgetUtils.TEXTURE_LOC, markerArea.x(), markerArea.y(), markerArea.width(), markerArea.height(), 2, 2, 2, 1, 12, 17, 18, 0);
        this.drawContents(guiGraphics, mouseX, mouseY, this.scrollOffsetY);
    }

    protected Rect calculateScrollbarMarkerArea() {
        int totalSpace = this.scrollRect.height() - 2;
        int scrollMarkerWidth = this.scrollRect.width() - 2;
        int scrollMarkerHeight = Math.round((float)totalSpace * Math.min(1.0f, (float)this.rect.height() / (float)this.contentRect.height()));
        scrollMarkerHeight = Math.max(scrollMarkerHeight, 14);
        int scrollbarMarkerY = Math.round((float)(totalSpace - scrollMarkerHeight) * this.scrollOffsetY);
        return new Rect(this.scrollRect.x() + 1, this.scrollRect.y() + 1 + scrollbarMarkerY, scrollMarkerWidth, scrollMarkerHeight);
    }

    public final boolean handleInput(double mouseX, double mouseY, IJeiUserInput userInput) {
        if (!userInput.isSimulate()) {
            this.dragOriginY = -1.0;
        }
        if (this.scrollRect.contains((int)mouseX, (int)mouseY)) {
            if (this.getHiddenAmount() == 0) {
                return false;
            }
            if (userInput.isSimulate()) {
                Rect scrollMarkerArea = this.calculateScrollbarMarkerArea();
                if (!scrollMarkerArea.contains((int)mouseX, (int)mouseY)) {
                    this.moveScrollbarCenterTo(scrollMarkerArea, mouseY);
                    scrollMarkerArea = this.calculateScrollbarMarkerArea();
                }
                this.dragOriginY = mouseY - (double)scrollMarkerArea.y();
            }
            return true;
        }
        return false;
    }

    public final boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
        if (this.getHiddenAmount() > 0) {
            this.scrollOffsetY -= this.calculateScrollAmount(scrollDeltaY);
            this.scrollOffsetY = Mth.clamp((float)this.scrollOffsetY, (float)0.0f, (float)1.0f);
        } else {
            this.scrollOffsetY = 0.0f;
        }
        return true;
    }

    public final boolean handleMouseDragged(double mouseX, double mouseY, InputConstants.Key mouseKey, double dragX, double dragY) {
        if (this.dragOriginY < 0.0 || mouseKey.getValue() != 0) {
            return false;
        }
        Rect scrollbarMarkerArea = this.calculateScrollbarMarkerArea();
        double topY = mouseY - this.dragOriginY;
        this.moveScrollbarTo(scrollbarMarkerArea, topY);
        return true;
    }

    public void getTooltip(ITooltipBuilder tooltip, double mouseX, double mouseY) {
        float scrollAmount = (float)this.getHiddenAmount() * this.scrollOffsetY;
        this.widgets.forEach(widget -> widget.getTooltip(tooltip, mouseX, mouseY + (double)scrollAmount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawContents(GuiGraphics guiGraphics, double mouseX, double mouseY, float scrollOffsetY) {
        PoseStack poseStack = guiGraphics.pose();
        PoseStack.Pose last = poseStack.last();
        Matrix4f pose = last.pose();
        ScreenRectangle scissorArea = JeiScrollWidget.transform(this.rect, pose);
        float scrollAmount = (float)this.getHiddenAmount() * scrollOffsetY;
        guiGraphics.enableScissor(scissorArea.left(), scissorArea.top(), scissorArea.right(), scissorArea.bottom());
        poseStack.pushPose();
        poseStack.translate(0.0, (double)(-scrollAmount), 0.0);
        try {
            this.widgets.forEach(widget -> widget.drawWidget(guiGraphics, mouseX, mouseY + (double)scrollAmount));
        }
        finally {
            poseStack.popPose();
            guiGraphics.disableScissor();
        }
    }

    private void moveScrollbarCenterTo(Rect scrollMarkerArea, double centerY) {
        double topY = centerY - (double)scrollMarkerArea.height() / 2.0;
        this.moveScrollbarTo(scrollMarkerArea, topY);
    }

    private void moveScrollbarTo(Rect scrollMarkerArea, double topY) {
        int minY = this.scrollRect.y();
        int maxY = this.scrollRect.y() + this.scrollRect.height() - scrollMarkerArea.height();
        double relativeY = topY - (double)minY;
        int totalSpace = maxY - minY;
        this.scrollOffsetY = (float)(relativeY / (double)totalSpace);
        this.scrollOffsetY = Mth.clamp((float)this.scrollOffsetY, (float)0.0f, (float)1.0f);
    }

    private float calculateScrollAmount(double scrollDeltaY) {
        int totalHeight = Math.max(1, this.contentRect.height() - this.rect.height());
        double scrollAmount = scrollDeltaY * 8.0;
        return (float)(scrollAmount / (double)totalHeight);
    }

    private int getHiddenAmount() {
        return Math.max(this.contentRect.height() - this.rect.height(), 0);
    }

    @NotNull
    public static ScreenRectangle transform(Rect rect, Matrix4f pose) {
        Vector3f topLeft = new Vector3f((float)rect.x(), (float)rect.y(), 1.0f);
        Vector3f bottomRight = new Vector3f((float)(rect.x() + rect.width()), (float)(rect.y() + rect.height()), 1.0f);
        topLeft = pose.transformPosition(topLeft);
        bottomRight = pose.transformPosition(bottomRight);
        int x = Math.round(topLeft.x);
        int y = Math.round(topLeft.y);
        return new ScreenRectangle(x, y, Math.round(bottomRight.x) - x, Math.round(bottomRight.y) - y);
    }

    @NotNull
    private static Rect calculateScrollArea(int width, int height) {
        return new Rect(width - 8, 0, 8, height);
    }

    public static int getScrollBoxScrollbarExtraWidth() {
        return 10;
    }
}

