/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.jei.compatibility.jei;

import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.compatibility.common.BlockLootType;
import com.yanny.ali.configuration.LootCategory;
import com.yanny.ali.jei.compatibility.jei.JeiBaseLoot;
import com.yanny.ali.jei.compatibility.jei.JeiBlockSlotWidget;
import com.yanny.ali.jei.compatibility.jei.JeiLootSlotWidget;
import com.yanny.ali.jei.compatibility.jei.RecipeHolder;
import com.yanny.ali.plugin.client.widget.LootTableWidget;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import oshi.util.tuples.Pair;

public class JeiBlockLoot
extends JeiBaseLoot<BlockLootType, Block> {
    public JeiBlockLoot(IGuiHelper guiHelper, RecipeType<RecipeHolder<BlockLootType>> recipeType, LootCategory<Block> lootCategory, Component title, IDrawable icon) {
        super(guiHelper, recipeType, lootCategory, title, icon);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<BlockLootType> recipe, IFocusGroup iFocusGroup) {
        super.setRecipe(builder, recipe, iFocusGroup);
        IRecipeSlotBuilder slotBuilder = builder.addInputSlot().setSlotName("block");
        if (recipe.type().block() instanceof BushBlock || recipe.type().block().asItem() == Items.AIR) {
            ((IRecipeSlotBuilder)slotBuilder.setPosition(72, 5)).setOutputSlotBackground();
        } else {
            ((IRecipeSlotBuilder)slotBuilder.setPosition(72, 0)).setStandardSlotBackground();
        }
        slotBuilder.addItemLike((ItemLike)recipe.type().block());
    }

    @Override
    Pair<List<IRecipeWidget>, List<IRecipeSlotDrawable>> getWidgets(IRecipeExtrasBuilder builder, BlockLootType recipe) {
        LinkedList widgets = new LinkedList();
        LinkedList slotDrawables = new LinkedList();
        builder.getRecipeSlots().findSlotByName("block").ifPresent(slotDrawable -> {
            if (recipe.block() instanceof BushBlock || recipe.block().asItem() == Items.AIR) {
                widgets.add(new JeiBlockSlotWidget((IRecipeSlotDrawable)slotDrawable, recipe.block(), 72, 5));
                slotDrawables.add(slotDrawable);
            } else {
                widgets.add(new JeiLootSlotWidget((IRecipeSlotDrawable)slotDrawable, 72, 0, new RangeValue(1.0f)));
                slotDrawables.add(slotDrawable);
            }
        });
        return new Pair(widgets, slotDrawables);
    }

    @Override
    int getYOffset(BlockLootType recipe) {
        boolean isSpecial = recipe.block() instanceof BushBlock || recipe.block().asItem() == Items.AIR;
        return isSpecial ? 30 : 22;
    }

    @Override
    IWidget getRootWidget(IWidgetUtils utils, IDataNode entry, RelativeRect rect, int maxWidth) {
        return new LootTableWidget(utils, entry, rect, maxWidth);
    }
}

