/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.jei.compatibility;

import com.mojang.logging.LogUtils;
import com.yanny.ali.Utils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.compatibility.common.BlockLootType;
import com.yanny.ali.compatibility.common.EntityLootType;
import com.yanny.ali.compatibility.common.GameplayLootType;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.common.IType;
import com.yanny.ali.compatibility.common.TradeLootType;
import com.yanny.ali.configuration.AliConfig;
import com.yanny.ali.configuration.LootCategory;
import com.yanny.ali.jei.compatibility.jei.JeiBlockLoot;
import com.yanny.ali.jei.compatibility.jei.JeiEntityLoot;
import com.yanny.ali.jei.compatibility.jei.JeiGameplayLoot;
import com.yanny.ali.jei.compatibility.jei.JeiTradeLoot;
import com.yanny.ali.jei.compatibility.jei.RecipeHolder;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.PluginManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@JeiPlugin
public class JeiCompatibility
implements IModPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<LootCategory<Block>, JeiBlockLoot> blockCategories = new LinkedHashMap<LootCategory<Block>, JeiBlockLoot>();
    private final Map<LootCategory<EntityType<?>>, JeiEntityLoot> entityCategories = new LinkedHashMap();
    private final Map<LootCategory<ResourceLocation>, JeiGameplayLoot> gameplayCategories = new LinkedHashMap<LootCategory<ResourceLocation>, JeiGameplayLoot>();
    private final Map<LootCategory<ResourceLocation>, JeiTradeLoot> tradeCategories = new LinkedHashMap<LootCategory<ResourceLocation>, JeiTradeLoot>();

    public void onRuntimeUnavailable() {
        this.blockCategories.clear();
        this.entityCategories.clear();
        this.gameplayCategories.clear();
        this.tradeCategories.clear();
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        AliConfig config = PluginManager.COMMON_REGISTRY.getConfiguration();
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        this.blockCategories.clear();
        this.entityCategories.clear();
        this.gameplayCategories.clear();
        this.tradeCategories.clear();
        this.blockCategories.putAll(config.blockCategories.stream().collect(JeiCompatibility.getCollector(guiHelper, JeiBlockLoot::new)));
        this.entityCategories.putAll(config.entityCategories.stream().collect(JeiCompatibility.getCollector(guiHelper, JeiEntityLoot::new)));
        this.gameplayCategories.putAll(config.gameplayCategories.stream().collect(JeiCompatibility.getCollector(guiHelper, JeiGameplayLoot::new)));
        this.tradeCategories.putAll(config.tradeCategories.stream().collect(JeiCompatibility.getCollector(guiHelper, JeiTradeLoot::new)));
        this.blockCategories.values().forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
        this.entityCategories.values().forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
        this.gameplayCategories.values().forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
        this.tradeCategories.values().forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        GenericUtils.register(registration, this::registerData);
    }

    private void registerData(IRecipeRegistration registration, byte[] fullCompressedData) {
        AliClientRegistry clientRegistry = PluginManager.CLIENT_REGISTRY;
        AliConfig config = PluginManager.COMMON_REGISTRY.getConfiguration();
        ClientLevel level = Minecraft.getInstance().level;
        LOGGER.info("Adding loot information to JEI");
        if (level != null) {
            HashMap blockRecipeTypes = new HashMap();
            HashMap entityRecipeTypes = new HashMap();
            HashMap gameplayRecipeTypes = new HashMap();
            HashMap tradeRecipeTypes = new HashMap();
            GenericUtils.processData(level, clientRegistry, config, fullCompressedData, (node, location, block, outputs) -> {
                RecipeType recipeType = null;
                for (JeiBlockLoot recipeCategory : this.blockCategories.values()) {
                    if (!recipeCategory.getLootCategory().validate(block)) continue;
                    if (recipeCategory.getLootCategory().isHidden()) {
                        return;
                    }
                    recipeType = recipeCategory.getRecipeType();
                    break;
                }
                if (recipeType != null) {
                    blockRecipeTypes.computeIfAbsent(recipeType, p -> new LinkedList()).add(new BlockLootType((Block)block, (IDataNode)node, Collections.emptyList(), (List<ItemStack>)outputs));
                }
            }, (node, location, entity, outputs) -> {
                RecipeType recipeType = null;
                for (JeiEntityLoot recipeCategory : this.entityCategories.values()) {
                    if (!recipeCategory.getLootCategory().validate(entity)) continue;
                    if (recipeCategory.getLootCategory().isHidden()) {
                        return;
                    }
                    recipeType = recipeCategory.getRecipeType();
                    break;
                }
                if (recipeType != null) {
                    entityRecipeTypes.computeIfAbsent(recipeType, p -> new LinkedList()).add(new EntityLootType((EntityType<?>)entity, (ResourceLocation)location, (IDataNode)node, Collections.emptyList(), (List<ItemStack>)outputs));
                }
            }, (node, location, outputs) -> {
                RecipeType recipeType = null;
                for (JeiGameplayLoot recipeCategory : this.gameplayCategories.values()) {
                    if (!recipeCategory.getLootCategory().validate(location)) continue;
                    if (recipeCategory.getLootCategory().isHidden()) {
                        return;
                    }
                    recipeType = recipeCategory.getRecipeType();
                    break;
                }
                if (recipeType != null) {
                    gameplayRecipeTypes.computeIfAbsent(recipeType, p -> new LinkedList()).add(new GameplayLootType((IDataNode)node, (ResourceLocation)location, Collections.emptyList(), (List<ItemStack>)outputs));
                }
            }, (node, location, inputs, outputs) -> {
                RecipeType recipeType = null;
                for (JeiTradeLoot recipeCategory : this.tradeCategories.values()) {
                    if (!recipeCategory.getLootCategory().validate(location)) continue;
                    if (recipeCategory.getLootCategory().isHidden()) {
                        return;
                    }
                    recipeType = recipeCategory.getRecipeType();
                    break;
                }
                if (recipeType != null) {
                    tradeRecipeTypes.computeIfAbsent(recipeType, p -> new LinkedList()).add(new TradeLootType((IDataNode)node, location.getPath(), (List<ItemStack>)inputs, (List<ItemStack>)outputs));
                }
            }, (node, location, inputs, outputs) -> {
                RecipeType recipeType = null;
                for (JeiTradeLoot recipeCategory : this.tradeCategories.values()) {
                    if (!recipeCategory.getLootCategory().validate(location)) continue;
                    if (recipeCategory.getLootCategory().isHidden()) {
                        return;
                    }
                    recipeType = recipeCategory.getRecipeType();
                    break;
                }
                if (recipeType != null) {
                    tradeRecipeTypes.computeIfAbsent(recipeType, p -> new LinkedList()).add(new TradeLootType((IDataNode)node, location.getPath(), (List<ItemStack>)inputs, (List<ItemStack>)outputs));
                }
            });
            for (Map.Entry entry : blockRecipeTypes.entrySet()) {
                registration.addRecipes((RecipeType)entry.getKey(), ((List)entry.getValue()).stream().map(RecipeHolder::new).toList());
            }
            for (Map.Entry entry : entityRecipeTypes.entrySet()) {
                registration.addRecipes((RecipeType)entry.getKey(), ((List)entry.getValue()).stream().map(RecipeHolder::new).toList());
            }
            for (Map.Entry entry : gameplayRecipeTypes.entrySet()) {
                registration.addRecipes((RecipeType)entry.getKey(), ((List)entry.getValue()).stream().map(RecipeHolder::new).toList());
            }
            for (Map.Entry entry : tradeRecipeTypes.entrySet()) {
                registration.addRecipes((RecipeType)entry.getKey(), ((List)entry.getValue()).stream().map(RecipeHolder::new).toList());
            }
        } else {
            LOGGER.warn("JEI integration was not loaded! Level is null!");
        }
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return Utils.modLoc("jei_plugin");
    }

    private static <T, U, V extends IType> T createCategory(IGuiHelper guiHelper, LootCategory<U> e, LootConstructor<T, U, V> constructor) {
        RecipeType recipeType = RecipeType.create((String)e.getKey().getNamespace(), (String)e.getKey().getPath(), RecipeHolder.class);
        MutableComponent title = Component.translatable((String)("emi.category." + e.getKey().getNamespace() + "." + e.getKey().getPath().replace('/', '.')));
        return constructor.construct(guiHelper, recipeType, e, (Component)title, guiHelper.createDrawableItemStack(e.getIcon().getDefaultInstance()));
    }

    @NotNull
    private static <T, U, V extends IType> Collector<LootCategory<U>, ?, Map<LootCategory<U>, T>> getCollector(IGuiHelper guiHelper, LootConstructor<T, U, V> supplier) {
        return Collectors.toMap(e -> e, e -> JeiCompatibility.createCategory(guiHelper, e, supplier), (a, b) -> a, LinkedHashMap::new);
    }

    @FunctionalInterface
    private static interface LootConstructor<T, U, V extends IType> {
        public T construct(IGuiHelper var1, RecipeType<RecipeHolder<V>> var2, LootCategory<U> var3, Component var4, IDrawable var5);
    }
}

