/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.common;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import com.yanny.ali.Utils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.Rect;
import com.yanny.ali.compatibility.common.QuadConsumer;
import com.yanny.ali.compatibility.common.TriConsumer;
import com.yanny.ali.configuration.AliConfig;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.plugin.common.nodes.LootTableNode;
import com.yanny.ali.plugin.common.trades.TradeNode;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import org.slf4j.Logger;
import oshi.util.tuples.Pair;

public class GenericUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation TEXTURE_LOC = Utils.modLoc("textures/gui/gui.png");
    private static final int WIDGET_SIZE = 36;
    private static final int DOTS_WIDTH = Minecraft.getInstance().font.width("...");
    private static CompletableFuture<byte[]> lastProcessedFuture = null;

    public static void renderEntity(Entity entity, Rect bounds, int fullWidth, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        Window window = minecraft.getWindow();
        PoseStack poseStack = guiGraphics.pose();
        Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)poseStack.last().pose());
        Matrix4f projectionMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        Matrix4f mvpMatrix = projectionMatrix.mul((Matrix4fc)modelViewMatrix);
        Vector4f topLeftWorld = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        Vector4f topLeftClip = mvpMatrix.transform(topLeftWorld);
        Vector4f topLeftNDC = new Vector4f(topLeftClip.x / topLeftClip.w, topLeftClip.y / topLeftClip.w, 0.0f, 1.0f);
        int screenX = Math.round((topLeftNDC.x + 1.0f) / 2.0f * (float)window.getGuiScaledWidth());
        int screenY = Math.round((1.0f - topLeftNDC.y) / 2.0f * (float)window.getGuiScaledHeight());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            guiGraphics.pose().pushPose();
            guiGraphics.blit(TEXTURE_LOC, bounds.x(), bounds.y(), bounds.width(), bounds.height(), 0.0f, 36.0f, 36, 36, 256, 256);
            guiGraphics.enableScissor(screenX + bounds.x() + 1, screenY + bounds.y() + 1, screenX + bounds.right() - 1, screenY + bounds.bottom() - 1);
            EntityDimensions dimensions = entity.getType().getDimensions();
            InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(-screenX + bounds.x()), (int)(-screenY + bounds.y()), (int)(screenX + bounds.right()), (int)(screenY + bounds.bottom()), (int)((int)Math.min(20.0f / dimensions.height(), 20.0f / dimensions.width())), (float)0.0625f, (float)mouseX, (float)mouseY, (LivingEntity)livingEntity);
            guiGraphics.disableScissor();
            guiGraphics.pose().popPose();
        }
    }

    @NotNull
    public static Component ellipsis(String text, String fallback, int maxWidth) {
        Font font = Minecraft.getInstance().font;
        text = Language.getInstance().getOrDefault(text, GenericUtils.getFallbackText(fallback));
        if (font.width(text) > maxWidth) {
            int index = 20;
            while (font.width(text.substring(0, index + 1) + DOTS_WIDTH) <= maxWidth) {
                ++index;
            }
            return Component.literal((String)(text.substring(0, index) + "..."));
        }
        return Component.literal((String)text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Pair<Map<ResourceLocation, LootData>, Map<ResourceLocation, TradeData>> decompressLootData(byte[] fullCompressedData, RegistryAccess registryAccess) {
        HashMap<ResourceLocation, LootData> lootData = new HashMap<ResourceLocation, LootData>();
        HashMap<ResourceLocation, TradeData> tradeData = new HashMap<ResourceLocation, TradeData>();
        ByteArrayInputStream bis = new ByteArrayInputStream(fullCompressedData);
        ByteBuf decompressedBuf = Unpooled.buffer();
        try (GZIPInputStream gzip = new GZIPInputStream(bis);){
            decompressedBuf.writeBytes(gzip.readAllBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        RegistryFriendlyByteBuf readerBuf = new RegistryFriendlyByteBuf(decompressedBuf, registryAccess);
        try {
            AliClientRegistry utils = PluginManager.CLIENT_REGISTRY;
            int lootDataCount = readerBuf.readInt();
            for (int i = 0; i < lootDataCount; ++i) {
                ResourceLocation location = readerBuf.readResourceLocation();
                Object dataNode = utils.getDataNodeFactory(LootTableNode.ID).create(utils, readerBuf);
                List items = (List)ItemStack.OPTIONAL_LIST_STREAM_CODEC.decode((Object)readerBuf);
                lootData.put(location, new LootData((IDataNode)dataNode, items));
            }
            int tradeDataCount = readerBuf.readInt();
            for (int i = 0; i < tradeDataCount; ++i) {
                ResourceLocation location = readerBuf.readResourceLocation();
                Object dataNode = utils.getDataNodeFactory(TradeNode.ID).create(utils, readerBuf);
                List<Item> inputs = ((ArrayList)readerBuf.readCollection(ArrayList::new, FriendlyByteBuf::readResourceLocation)).stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).toList();
                List<Item> outputs = ((ArrayList)readerBuf.readCollection(ArrayList::new, FriendlyByteBuf::readResourceLocation)).stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).toList();
                tradeData.put(location, new TradeData((IDataNode)dataNode, inputs, outputs));
            }
            Object dataNode = utils.getDataNodeFactory(TradeNode.ID).create(utils, readerBuf);
            List<Item> inputs = ((ArrayList)readerBuf.readCollection(ArrayList::new, FriendlyByteBuf::readResourceLocation)).stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).toList();
            List<Item> outputs = ((ArrayList)readerBuf.readCollection(ArrayList::new, FriendlyByteBuf::readResourceLocation)).stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).toList();
            tradeData.put(ResourceLocation.withDefaultNamespace((String)"empty"), new TradeData((IDataNode)dataNode, inputs, outputs));
        }
        finally {
            readerBuf.release();
        }
        return new Pair(lootData, tradeData);
    }

    public static void processData(ClientLevel level, AliClientRegistry clientRegistry, AliConfig config, byte[] fullCompressedData, QuadConsumer<IDataNode, ResourceLocation, Block, List<ItemStack>> blockConsumer, QuadConsumer<IDataNode, ResourceLocation, EntityType<?>, List<ItemStack>> entityConsumer, TriConsumer<IDataNode, ResourceLocation, List<ItemStack>> gameplayConsumer, QuadConsumer<IDataNode, ResourceLocation, List<ItemStack>, List<ItemStack>> traderConsumer, QuadConsumer<IDataNode, ResourceLocation, List<ItemStack>, List<ItemStack>> wanderingTraderConsumer) {
        List<ItemStack> outputs;
        List<ItemStack> inputs;
        TradeData tradeEntry;
        Object location;
        Pair<Map<ResourceLocation, LootData>, Map<ResourceLocation, TradeData>> pair = GenericUtils.decompressLootData(fullCompressedData, level.registryAccess());
        Map lootData = (Map)pair.getA();
        Map tradeData = (Map)pair.getB();
        for (Block block : BuiltInRegistries.BLOCK) {
            LootData data;
            ResourceKey resourceKey = block.getLootTable();
            if (resourceKey == null || (data = (LootData)lootData.get(location = resourceKey.location())) == null) continue;
            blockConsumer.accept(data.node, (ResourceLocation)location, block, data.items);
            lootData.remove(location);
        }
        for (EntityType entityType : BuiltInRegistries.ENTITY_TYPE) {
            if (config.disabledEntities.stream().anyMatch(f -> f.equals((Object)BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityType)))) {
                lootData.remove(entityType.getDefaultLootTable().location());
                continue;
            }
            List<Entity> list = clientRegistry.createEntities(entityType, (Level)level);
            for (Entity entity : list) {
                Mob mob;
                ResourceKey resourceKey;
                if (!(entity instanceof Mob) || (resourceKey = (mob = (Mob)entity).getLootTable()) == null) continue;
                ResourceLocation location2 = resourceKey.location();
                LootData data = (LootData)lootData.get(location2);
                if (data != null) {
                    entityConsumer.accept(data.node, location2, entityType, data.items);
                }
                lootData.remove(location2);
            }
        }
        for (Map.Entry entry : lootData.entrySet()) {
            gameplayConsumer.accept(((LootData)entry.getValue()).node, (ResourceLocation)entry.getKey(), ((LootData)entry.getValue()).items());
        }
        lootData.clear();
        List<Map.Entry> entries = BuiltInRegistries.VILLAGER_PROFESSION.entrySet().stream().sorted(Comparator.comparing(a -> ((ResourceKey)a.getKey()).location().getPath())).toList();
        for (Map.Entry entry : entries) {
            location = ((ResourceKey)entry.getKey()).location();
            tradeEntry = (TradeData)tradeData.get(location);
            if (tradeEntry == null) continue;
            inputs = tradeEntry.inputs.stream().map(Item::getDefaultInstance).toList();
            outputs = tradeEntry.outputs.stream().map(Item::getDefaultInstance).toList();
            traderConsumer.accept(tradeEntry.node, (ResourceLocation)location, inputs, outputs);
            tradeData.remove(location);
        }
        for (Map.Entry entry : tradeData.entrySet()) {
            location = (ResourceLocation)entry.getKey();
            tradeEntry = (TradeData)tradeData.get(location);
            if (tradeEntry == null) continue;
            inputs = tradeEntry.inputs.stream().map(Item::getDefaultInstance).toList();
            outputs = tradeEntry.outputs.stream().map(Item::getDefaultInstance).toList();
            wanderingTraderConsumer.accept(tradeEntry.node, (ResourceLocation)location, inputs, outputs);
        }
        tradeData.clear();
    }

    public static <T> void register(T emiRegistry, BiConsumer<T, byte[]> registerData) {
        LOGGER.info("Starting data registration...");
        while (true) {
            CompletableFuture<byte[]> futureData;
            if ((futureData = PluginManager.CLIENT_REGISTRY.getCurrentDataFuture()) == lastProcessedFuture && futureData.isDone()) {
                LOGGER.info("Data checks out: Already received. Reusing cached data for registration.");
            }
            if (futureData.isDone()) {
                LOGGER.info("Data already received, processing instantly.");
            } else {
                LOGGER.info("Blocking this thread until all data are received!");
            }
            try {
                byte[] fullCompressedData = futureData.get();
                registerData.accept(emiRegistry, fullCompressedData);
                lastProcessedFuture = futureData;
                LOGGER.info("Data registration finished successfully.");
            }
            catch (CancellationException e) {
                LOGGER.warn("Data reception was cancelled. Retrying with new data stream...");
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.error("Registration thread interrupted!");
            }
            catch (ExecutionException e) {
                LOGGER.error("Failed to finish registering data with error {}", (Object)e.getCause().getMessage());
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
                LOGGER.error("Failed to finish registering data with unexpected error {}", (Object)e.getMessage());
            }
            break;
        }
    }

    private static String getFallbackText(String fallback) {
        List pathSegments = Pattern.compile("/").splitAsStream(fallback).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        Collections.reverse(pathSegments);
        return pathSegments.stream().flatMap(segment -> Arrays.stream(segment.split("_"))).filter(s -> !s.isEmpty()).map(word -> Character.toUpperCase(word.charAt(0)) + word.substring(1)).collect(Collectors.joining(" "));
    }

    public record LootData(IDataNode node, List<ItemStack> items) {
    }

    public record TradeData(IDataNode node, List<Item> inputs, List<Item> outputs) {
    }
}

