/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.api;

public class RelativeRect {
    public static final RelativeRect ZERO = new RelativeRect(0, 0, 0, 0){

        @Override
        public int getX() {
            return 0;
        }

        @Override
        public int getY() {
            return 0;
        }
    };
    private int offsetX;
    private int offsetY;
    private int width;
    private int height;
    private final RelativeRect parent;

    public RelativeRect(int offsetX, int offsetY) {
        this(offsetX, offsetY, 0, 0);
    }

    public RelativeRect(int offsetX, int offsetY, int width, int height) {
        this(offsetX, offsetY, width, height, ZERO);
    }

    public RelativeRect(int offsetX, int offsetY, int width, int height, RelativeRect parent) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.width = width;
        this.height = height;
        this.parent = parent;
    }

    public int getX() {
        return this.parent.getX() + this.offsetX;
    }

    public int getY() {
        return this.parent.getY() + this.offsetY;
    }

    public int getRight() {
        return this.getX() + this.width;
    }

    public int getBottom() {
        return this.getY() + this.height;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setOffset(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public boolean contains(int x, int y) {
        int thisX = this.getX();
        int thisY = this.getY();
        return x >= thisX && x < thisX + this.width && y >= thisY && y < thisY + this.height;
    }
}

