/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.loudhorns.block;

import net.mcreator.loudhorns.init.LoudHornsModBlocks;
import net.mcreator.loudhorns.procedures.LoudHornTopNeighbourBlockChangesProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LoudHornTopBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public LoudHornTopBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.ANVIL).strength(5.0f, 1200.0f).requiresCorrectToolForDrops().noOcclusion().pushReaction(PushReaction.DESTROY).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)LoudHornTopBlock.box((double)5.0, (double)13.0, (double)2.0, (double)11.0, (double)15.0, (double)8.0), (VoxelShape[])new VoxelShape[]{LoudHornTopBlock.box((double)6.0, (double)0.0, (double)3.0, (double)10.0, (double)14.0, (double)7.0), LoudHornTopBlock.box((double)6.0, (double)5.0, (double)7.0, (double)10.0, (double)9.0, (double)19.0), LoudHornTopBlock.box((double)7.0, (double)4.0, (double)13.5, (double)9.0, (double)5.0, (double)15.5), LoudHornTopBlock.box((double)7.5, (double)0.0, (double)14.0, (double)8.5, (double)4.0, (double)15.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)LoudHornTopBlock.box((double)5.0, (double)13.0, (double)8.0, (double)11.0, (double)15.0, (double)14.0), (VoxelShape[])new VoxelShape[]{LoudHornTopBlock.box((double)6.0, (double)0.0, (double)9.0, (double)10.0, (double)14.0, (double)13.0), LoudHornTopBlock.box((double)6.0, (double)5.0, (double)-3.0, (double)10.0, (double)9.0, (double)9.0), LoudHornTopBlock.box((double)7.0, (double)4.0, (double)0.5, (double)9.0, (double)5.0, (double)2.5), LoudHornTopBlock.box((double)7.5, (double)0.0, (double)1.0, (double)8.5, (double)4.0, (double)2.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)LoudHornTopBlock.box((double)2.0, (double)13.0, (double)5.0, (double)8.0, (double)15.0, (double)11.0), (VoxelShape[])new VoxelShape[]{LoudHornTopBlock.box((double)3.0, (double)0.0, (double)6.0, (double)7.0, (double)14.0, (double)10.0), LoudHornTopBlock.box((double)7.0, (double)5.0, (double)6.0, (double)19.0, (double)9.0, (double)10.0), LoudHornTopBlock.box((double)13.5, (double)4.0, (double)7.0, (double)15.5, (double)5.0, (double)9.0), LoudHornTopBlock.box((double)14.0, (double)0.0, (double)7.5, (double)15.0, (double)4.0, (double)8.5)});
            case Direction.WEST -> Shapes.or((VoxelShape)LoudHornTopBlock.box((double)8.0, (double)13.0, (double)5.0, (double)14.0, (double)15.0, (double)11.0), (VoxelShape[])new VoxelShape[]{LoudHornTopBlock.box((double)9.0, (double)0.0, (double)6.0, (double)13.0, (double)14.0, (double)10.0), LoudHornTopBlock.box((double)-3.0, (double)5.0, (double)6.0, (double)9.0, (double)9.0, (double)10.0), LoudHornTopBlock.box((double)0.5, (double)4.0, (double)7.0, (double)2.5, (double)5.0, (double)9.0), LoudHornTopBlock.box((double)1.0, (double)0.0, (double)7.5, (double)2.0, (double)4.0, (double)8.5)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)LoudHornsModBlocks.LOUD_HORN.get());
    }

    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return PathType.BLOCKED;
    }

    public void neighborChanged(BlockState blockstate, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.neighborChanged(blockstate, world, pos, neighborBlock, fromPos, moving);
        LoudHornTopNeighbourBlockChangesProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }
}

