/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.impl.client.models;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import earth.terrarium.athena.api.client.models.AthenaBlockModel;
import earth.terrarium.athena.api.client.models.AthenaModelAttributes;
import earth.terrarium.athena.api.client.models.AthenaModelFactory;
import earth.terrarium.athena.api.client.models.AthenaQuad;
import earth.terrarium.athena.api.client.utils.AppearanceAndTintGetter;
import earth.terrarium.athena.api.client.utils.CtmState;
import earth.terrarium.athena.api.client.utils.CtmUtils;
import earth.terrarium.athena.impl.client.models.ctm.ConnectedTextureMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ConnectedBlockModel
implements AthenaBlockModel {
    public static final AthenaModelFactory FACTORY = new Factory();
    private final ConnectedTextureMap materials;
    private final BiPredicate<BlockState, BlockState> connectTo;
    private final AthenaModelAttributes attributes;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.21.11")
    public ConnectedBlockModel(ConnectedTextureMap materials, BiPredicate<BlockState, BlockState> connectTo) {
        this(materials, connectTo, AthenaModelAttributes.EMPTY);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.21.11")
    public ConnectedBlockModel(ConnectedTextureMap materials, BiPredicate<BlockState, BlockState> connectTo, RenderType renderType) {
        this(materials, connectTo, new AthenaModelAttributes(null, renderType));
    }

    public ConnectedBlockModel(ConnectedTextureMap materials, BiPredicate<BlockState, BlockState> connectTo, AthenaModelAttributes attributes) {
        this.materials = materials;
        this.connectTo = connectTo;
        this.attributes = attributes;
    }

    @Override
    public List<AthenaQuad> getQuads(AppearanceAndTintGetter level, BlockState state, BlockPos pos, Direction direction) {
        if (CtmUtils.checkRelative(level, state, pos, direction)) {
            return List.of();
        }
        CtmState ctm = CtmState.from(level, state, pos, direction, CtmUtils.check(level, state, pos, direction, this.connectTo));
        if (ctm.allTrue()) {
            return List.of(AthenaQuad.withSprite(this.materials.getTexture(direction, 1)));
        }
        return List.of(AthenaQuad.withState(this.materials, direction, ctm.up(), ctm.left(), ctm.upLeft(), 0.0f, 0.5f, 1.0f, 0.5f), AthenaQuad.withState(this.materials, direction, ctm.up(), ctm.right(), ctm.upRight(), 0.5f, 1.0f, 1.0f, 0.5f), AthenaQuad.withState(this.materials, direction, ctm.down(), ctm.left(), ctm.downLeft(), 0.0f, 0.5f, 0.5f, 0.0f), AthenaQuad.withState(this.materials, direction, ctm.down(), ctm.right(), ctm.downRight(), 0.5f, 1.0f, 0.5f, 0.0f));
    }

    @Override
    public Map<Direction, List<AthenaQuad>> getDefaultQuads(Direction direction) {
        if (direction == null) {
            return Map.of();
        }
        return Map.of(direction, List.of(AthenaQuad.withState(this.materials, direction, false, false, false, 0.0f, 0.5f, 1.0f, 0.5f), AthenaQuad.withState(this.materials, direction, false, false, false, 0.5f, 1.0f, 1.0f, 0.5f), AthenaQuad.withState(this.materials, direction, false, false, false, 0.0f, 0.5f, 0.5f, 0.0f), AthenaQuad.withState(this.materials, direction, false, false, false, 0.5f, 1.0f, 0.5f, 0.0f)));
    }

    @Override
    public Int2ObjectMap<TextureAtlasSprite> getTextures(Function<Material, TextureAtlasSprite> getter) {
        return this.materials.getTextures(getter);
    }

    @Override
    @Nullable
    public AthenaModelAttributes getAttributes() {
        return this.attributes;
    }

    private static class Factory
    implements AthenaModelFactory {
        private Factory() {
        }

        @Override
        public Supplier<AthenaBlockModel> create(JsonObject json) {
            ConnectedTextureMap materials = CtmUtils.tryParse(GsonHelper.getAsJsonObject((JsonObject)json, (String)"ctm_textures"), Factory::parseDefaultMaterials);
            if (materials == null) {
                materials = CtmUtils.tryParse(GsonHelper.getAsJsonObject((JsonObject)json, (String)"ctm_textures"), Factory::parseMaterials);
            }
            if (materials == null) {
                throw new JsonSyntaxException("Expected either ctm_textures to have 5 entries for all textures or have directional textures for each direction or to have some directions and a default textures object.");
            }
            ConnectedTextureMap materialsFinal = materials;
            BiPredicate<BlockState, BlockState> conditions = CtmUtils.parseCondition(json);
            AthenaModelAttributes attributes = AthenaModelAttributes.fromJson(json);
            return () -> new ConnectedBlockModel(materialsFinal, conditions, attributes);
        }

        private static ConnectedTextureMap parseMaterials(JsonObject json) {
            ConnectedTextureMap materials = new ConnectedTextureMap();
            for (Direction direction : Direction.values()) {
                if (GsonHelper.isStringValue((JsonObject)json, (String)direction.getSerializedName())) {
                    materials.put(direction, CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)direction.getSerializedName())));
                    continue;
                }
                Int2ObjectMap<Material> directionMaterials = CtmUtils.parseCtmMaterials(GsonHelper.getAsJsonObject((JsonObject)json, (String)direction.getSerializedName(), (JsonObject)GsonHelper.getAsJsonObject((JsonObject)json, (String)"default")));
                materials.put(direction, directionMaterials);
            }
            return materials;
        }

        private static ConnectedTextureMap parseDefaultMaterials(JsonObject json) {
            Int2ObjectMap<Material> materials = CtmUtils.parseCtmMaterials(json);
            ConnectedTextureMap connectedTextureMap = new ConnectedTextureMap();
            for (Direction direction : Direction.values()) {
                connectedTextureMap.put(direction, materials);
            }
            return connectedTextureMap;
        }
    }
}

