/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.api.client.neoforge;

import earth.terrarium.athena.api.client.models.AthenaBlockModel;
import earth.terrarium.athena.api.client.models.AthenaModelAttributes;
import earth.terrarium.athena.api.client.models.AthenaQuad;
import earth.terrarium.athena.api.client.neoforge.ForgeAthenaUtils;
import earth.terrarium.athena.api.client.neoforge.WrappedGetter;
import earth.terrarium.athena.api.client.utils.AthenaUtils;
import earth.terrarium.athena.api.client.utils.NullableEnumMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.Optionull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AthenaBakedModel
implements IDynamicBakedModel {
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN};
    public static final ModelProperty<NullableEnumMap<Direction, Map<Direction, List<AthenaQuad>>>> DATA = new ModelProperty();
    private final AthenaBlockModel model;
    private final Int2ObjectMap<TextureAtlasSprite> textures;
    private final ChunkRenderTypeSet renderTypes;
    private final AthenaModelAttributes attributes;

    public AthenaBakedModel(AthenaBlockModel model, Function<Material, TextureAtlasSprite> function) {
        this.model = model;
        this.textures = this.model.getTextures(function);
        this.attributes = model.getAttributes();
        this.renderTypes = (ChunkRenderTypeSet)Optionull.map((Object)(this.attributes.getLayer() != null ? this.attributes.getLayer() : this.model.getRenderType()), xva$0 -> ChunkRenderTypeSet.of((RenderType[])new RenderType[]{xva$0}));
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, @NotNull RandomSource random, @NotNull ModelData data, @Nullable RenderType type) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        try {
            Map<Direction, List<AthenaQuad>> values = data.has(DATA) ? ((NullableEnumMap)data.get(DATA)).getOrDefault(direction, Map.of()) : this.model.getDefaultQuads(direction);
            values.forEach((dir, quadList) -> quads.addAll(this.bakeQuads((List<AthenaQuad>)quadList, (Direction)dir)));
        }
        catch (Exception e) {
            AthenaUtils.LOGGER.error("Error occurred while getting quads of Athena block model", (Throwable)e);
            throw e;
        }
        return quads;
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData data) {
        WrappedGetter getter = new WrappedGetter(level);
        NullableEnumMap<Direction, Map<Object, ArrayList<Object>>> quads = new NullableEnumMap<Direction, Map<Object, ArrayList<Object>>>(Direction.class);
        HashMap nonCullQuads = new HashMap();
        for (Direction direction : DIRECTIONS) {
            ArrayList<AthenaQuad> culledQuads = new ArrayList<AthenaQuad>();
            ArrayList<AthenaQuad> unculledQuads = new ArrayList<AthenaQuad>();
            for (AthenaQuad quad : this.model.getQuads(getter, state, pos, direction)) {
                if (quad.cull()) {
                    culledQuads.add(quad);
                    continue;
                }
                unculledQuads.add(quad);
            }
            quads.put(direction, Map.of(direction, culledQuads));
            nonCullQuads.put(direction, unculledQuads);
        }
        quads.put(null, nonCullQuads);
        return data.derive().with(DATA, quads).build();
    }

    private List<BakedQuad> bakeQuads(List<AthenaQuad> quads, Direction direction) {
        ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>(quads.size());
        for (AthenaQuad quad : quads) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)this.textures.get(quad.sprite());
            if (sprite == null) continue;
            bakedQuads.addAll(ForgeAthenaUtils.bakeQuad(quad, direction, sprite, this.attributes.getTint()));
        }
        return bakedQuads;
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return true;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon() {
        if (this.textures.containsKey(0)) {
            return (TextureAtlasSprite)this.textures.get(0);
        }
        return Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).getSprite(MissingTextureAtlasSprite.getLocation());
    }

    @NotNull
    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        if (this.renderTypes != null) {
            return this.renderTypes;
        }
        return super.getRenderTypes(state, rand, data);
    }
}

