/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hangglider.helper;

import fuzs.hangglider.HangGlider;
import fuzs.hangglider.capability.GlidingCapability;
import fuzs.hangglider.config.ServerConfig;
import fuzs.hangglider.init.ModRegistry;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;

public class PlayerGlidingHelper {
    public static boolean isAllowedToGlide(Player player) {
        return !player.onGround() && !player.isPassenger() && !player.hasEffect(MobEffects.LEVITATION) && !player.getAbilities().flying && !player.isInWater() && player.getDeltaMovement().y < 0.0;
    }

    public static boolean isWearingElytra(Player player) {
        return player.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof ElytraItem;
    }

    public static boolean isValidGlider(ItemStack stack) {
        return stack.is(ModRegistry.HANG_GLIDERS_ITEM_TAG) && (ElytraItem.isFlyEnabled((ItemStack)stack) || !stack.isDamageableItem());
    }

    public static ItemStack getGliderInHand(Player player) {
        if (((GlidingCapability)ModRegistry.GLIDING_CAPABILITY.get((Object)player)).isGliderDeployed()) {
            for (InteractionHand interactionHand : InteractionHand.values()) {
                ItemStack itemInHand = player.getItemInHand(interactionHand);
                if (!PlayerGlidingHelper.isValidGlider(itemInHand)) continue;
                return itemInHand;
            }
        }
        return ItemStack.EMPTY;
    }

    public static EquipmentSlot getGliderHoldingHand(Player player) {
        for (InteractionHand interactionHand : InteractionHand.values()) {
            ItemStack itemInHand = player.getItemInHand(interactionHand);
            if (!itemInHand.is(ModRegistry.HANG_GLIDERS_ITEM_TAG)) continue;
            return interactionHand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
        }
        return null;
    }

    public static ServerConfig.GliderConfig getGliderMaterialSettings(ItemStack itemStack) {
        if (itemStack.is(ModRegistry.REINFORCED_HANG_GLIDERS_ITEM_TAG)) {
            return ((ServerConfig)HangGlider.CONFIG.get(ServerConfig.class)).reinforcedHangGlider;
        }
        if (itemStack.is(ModRegistry.HANG_GLIDERS_ITEM_TAG)) {
            return ((ServerConfig)HangGlider.CONFIG.get(ServerConfig.class)).hangGlider;
        }
        throw new IllegalArgumentException(String.valueOf(itemStack) + " is no hang glider");
    }
}

