/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.patreon.pkts;

import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import io.github.flemmli97.tenshilib.patreon.PatreonDataManager;
import io.github.flemmli97.tenshilib.patreon.PatreonPlayerSetting;
import io.github.flemmli97.tenshilib.patreon.RenderLocation;
import io.github.flemmli97.tenshilib.patreon.TenshiLibPatreonPlatform;
import io.github.flemmli97.tenshilib.patreon.effects.PatreonEffectConfig;
import io.github.flemmli97.tenshilib.patreon.effects.PatreonEffects;
import io.github.flemmli97.tenshilib.patreon.pkts.S2CEffectUpdatePkt;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class C2SEffectUpdatePkt
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<C2SEffectUpdatePkt> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tenshilib", (String)"c2s_patreon_effect_pkt"));
    public static final StreamCodec<RegistryFriendlyByteBuf, C2SEffectUpdatePkt> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, C2SEffectUpdatePkt>(){

        public C2SEffectUpdatePkt decode(RegistryFriendlyByteBuf buf) {
            return new C2SEffectUpdatePkt(buf.readUtf(), buf.readBoolean(), (RenderLocation)buf.readEnum(RenderLocation.class), buf.readInt());
        }

        public void encode(RegistryFriendlyByteBuf buf, C2SEffectUpdatePkt pkt) {
            buf.writeUtf(pkt.id);
            buf.writeBoolean(pkt.render);
            buf.writeEnum((Enum)pkt.location);
            buf.writeInt(pkt.color);
        }
    };
    public final String id;
    public final boolean render;
    public final RenderLocation location;
    public final int color;

    public C2SEffectUpdatePkt(String id, boolean render, RenderLocation location, int color) {
        this.id = id;
        this.render = render;
        this.location = location;
        this.color = color;
    }

    public static void handle(C2SEffectUpdatePkt pkt, ServerPlayer player) {
        PatreonEffectConfig eff;
        PatreonPlayerSetting setting = TenshiLibPatreonPlatform.INSTANCE.playerSettings((Player)player);
        int tier = PatreonDataManager.get(player.getUUID().toString()).tier();
        if (tier < 1 || (eff = PatreonEffects.get(pkt.id)) == null || eff.tier > tier) {
            setting.setEffect(null);
        } else {
            setting.read(pkt, pkt.id);
        }
        LoaderNetwork.INSTANCE.sendToTracking(new S2CEffectUpdatePkt(player.getId(), setting.effect() != null ? setting.effect().id() : "", setting.shouldRender(), setting.getRenderLocation(), setting.getColor()), (Entity)player);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

