/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.neoforge.loader.registry;

import io.github.flemmli97.tenshilib.common.attachment.AttachmentType;
import io.github.flemmli97.tenshilib.loader.registry.AttachmentRegister;
import io.github.flemmli97.tenshilib.neoforge.loader.registry.AttachmentTypeWrapper;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class AttachmentRegisterImpl
implements AttachmentRegister {
    @Override
    public AttachmentRegister.AttachmentRegistry of(String modid) {
        return new AttachmenRegistryImpl(modid);
    }

    @Override
    public <T> T getAttachment(Entity entity, AttachmentType<T> type) {
        if (!(type instanceof AttachmentTypeWrapper)) {
            throw new IllegalStateException("Unsupported type");
        }
        AttachmentTypeWrapper wrapper = (AttachmentTypeWrapper)type;
        return (T)entity.getData(wrapper.getNeoAttachment());
    }

    @Override
    public <T> Optional<T> getOptionalAttachment(Entity entity, AttachmentType<T> type) {
        if (!(type instanceof AttachmentTypeWrapper)) {
            throw new IllegalStateException("Unsupported type");
        }
        AttachmentTypeWrapper wrapper = (AttachmentTypeWrapper)type;
        return entity.getExistingData(wrapper.getNeoAttachment());
    }

    @Override
    public <T> T getAttachment(BlockEntity blockEntity, AttachmentType<T> type) {
        if (!(type instanceof AttachmentTypeWrapper)) {
            throw new IllegalStateException("Unsupported type");
        }
        AttachmentTypeWrapper wrapper = (AttachmentTypeWrapper)type;
        return (T)blockEntity.getData(wrapper.getNeoAttachment());
    }

    @Override
    public <T> Optional<T> getOptionalAttachment(BlockEntity blockEntity, AttachmentType<T> type) {
        if (!(type instanceof AttachmentTypeWrapper)) {
            throw new IllegalStateException("Unsupported type");
        }
        AttachmentTypeWrapper wrapper = (AttachmentTypeWrapper)type;
        return blockEntity.getExistingData(wrapper.getNeoAttachment());
    }

    static class AttachmenRegistryImpl
    implements AttachmentRegister.AttachmentRegistry {
        private final DeferredRegister<net.neoforged.neoforge.attachment.AttachmentType<?>> register;

        AttachmenRegistryImpl(String modid) {
            this.register = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)modid);
        }

        @Override
        public <T> Supplier<AttachmentType<T>> register(String name, AttachmentType.Builder<T> builder) {
            AttachmentTypeWrapper wrapper = new AttachmentTypeWrapper(builder.build());
            DeferredHolder value = this.register.register(name, wrapper::getNeoAttachment);
            return () -> {
                value.get();
                return wrapper;
            };
        }

        @Override
        public void registerContent() {
            IEventBus bus = ModList.get().getModContainerById(this.register.getNamespace()).map(ModContainer::getEventBus).orElse(null);
            if (bus == null) {
                throw new IllegalStateException("Unable to get mod eventbus for modid " + this.register.getNamespace());
            }
            this.register.register(bus);
        }
    }
}

