/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.mixin;

import io.github.flemmli97.tenshilib.common.effect.ExtendedMobEffect;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Inject(method={"onEffectAdded"}, at={@At(value="RETURN")})
    private void onAddedEffect(MobEffectInstance instance, Entity entity, CallbackInfo ci) {
        Object object = instance.getEffect().value();
        if (object instanceof ExtendedMobEffect) {
            ExtendedMobEffect ext = (ExtendedMobEffect)object;
            ext.onEffectAdded((LivingEntity)this, instance);
            if (ext.shouldSync() && !(this instanceof Player) && !((LivingEntity)this).level().isClientSide && ext.shouldSync()) {
                LoaderNetwork.INSTANCE.sendVanillaToTracking((Packet<?>)new ClientboundUpdateMobEffectPacket(((LivingEntity)this).getId(), instance, true), (Entity)((LivingEntity)this));
            }
        }
    }

    @Inject(method={"onEffectUpdated"}, at={@At(value="RETURN")})
    private void onUpdatedEffect(MobEffectInstance instance, boolean forced, Entity entity, CallbackInfo ci) {
        Object object = instance.getEffect().value();
        if (object instanceof ExtendedMobEffect) {
            ExtendedMobEffect ext = (ExtendedMobEffect)object;
            ext.onEffectUpdated((LivingEntity)this, instance);
            if (ext.shouldSync() && !(this instanceof Player) && !((LivingEntity)this).level().isClientSide) {
                LoaderNetwork.INSTANCE.sendVanillaToTracking((Packet<?>)new ClientboundUpdateMobEffectPacket(((LivingEntity)this).getId(), instance, false), (Entity)((LivingEntity)this));
            }
        }
    }

    @Inject(method={"onEffectRemoved"}, at={@At(value="RETURN")})
    private void onAddedEffect(MobEffectInstance instance, CallbackInfo ci) {
        Object object = instance.getEffect().value();
        if (object instanceof ExtendedMobEffect) {
            ExtendedMobEffect ext = (ExtendedMobEffect)object;
            ext.onEffectRemoved((LivingEntity)this, instance);
            if (ext.shouldSync() && !(this instanceof Player) && !((LivingEntity)this).level().isClientSide) {
                LoaderNetwork.INSTANCE.sendVanillaToTracking((Packet<?>)new ClientboundRemoveMobEffectPacket(((LivingEntity)this).getId(), instance.getEffect()), (Entity)((LivingEntity)this));
            }
        }
    }
}

