/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils;

import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelUtils {
    public static VoxelShape[] joinedOrDirs(ShapeBuilder ... shapes) {
        return new VoxelShape[]{VoxelUtils.joinedOr(Direction.from2DDataValue((int)0), shapes), VoxelUtils.joinedOr(Direction.from2DDataValue((int)1), shapes), VoxelUtils.joinedOr(Direction.from2DDataValue((int)2), shapes), VoxelUtils.joinedOr(Direction.from2DDataValue((int)3), shapes)};
    }

    public static VoxelShape joinedOr(Direction direction, ShapeBuilder ... shapes) {
        return Stream.of(shapes).map(s -> {
            switch (direction) {
                case EAST: {
                    return Block.box((double)(16.0 - s.z2), (double)s.y1, (double)s.x1, (double)(16.0 - s.z1), (double)s.y2, (double)s.x2);
                }
                case SOUTH: {
                    return Block.box((double)(16.0 - s.x2), (double)s.y1, (double)(16.0 - s.z2), (double)(16.0 - s.x1), (double)s.y2, (double)(16.0 - s.z1));
                }
                case WEST: {
                    return Block.box((double)s.z1, (double)s.y1, (double)(16.0 - s.x2), (double)s.z2, (double)s.y2, (double)(16.0 - s.x1));
                }
            }
            return Block.box((double)s.x1, (double)s.y1, (double)s.z1, (double)s.x2, (double)s.y2, (double)s.z2);
        }).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).orElseThrow();
    }

    public record ShapeBuilder(double x1, double y1, double z1, double x2, double y2, double z2) {
        public static ShapeBuilder of(double x1, double y1, double z1, double x2, double y2, double z2) {
            return new ShapeBuilder(x1, y1, z1, x2, y2, z2);
        }
    }
}

