/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;

public class CodecUtils {
    public static final Codec<ItemStack> ITEM_STACK_CODEC = CodecUtils.tryCodec(ItemStack.ITEM_NON_AIR_CODEC.flatXmap(h -> DataResult.success((Object)new ItemStack(h)), s -> s.getComponentsPatch().isEmpty() && s.getCount() == 1 ? DataResult.success((Object)s.getItemHolder()) : DataResult.error(() -> "Not default itemstack")), RecordCodecBuilder.create(inst -> inst.group((App)ItemStack.ITEM_NON_AIR_CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("count").forGetter(stack -> stack.getCount() == 1 ? Optional.empty() : Optional.of(stack.getCount())), (App)DataComponentPatch.CODEC.optionalFieldOf("components").forGetter(stack -> stack.getComponentsPatch().isEmpty() ? Optional.empty() : Optional.of(stack.getComponentsPatch()))).apply((Applicative)inst, (s, count, comp) -> new ItemStack(s, count.orElse(1).intValue(), comp.orElse(DataComponentPatch.EMPTY)))));

    public static <F> Codec<F> tryCodec(Codec<F> first, Codec<F> second) {
        return new TryCodec<F>(first, second);
    }

    public static <T extends Enum<T>> Codec<T> stringEnumCodec(Class<T> clss, T fallback) {
        return Codec.STRING.flatXmap(s -> {
            try {
                return DataResult.success(Enum.valueOf(clss, s));
            }
            catch (IllegalArgumentException e) {
                if (fallback != null) {
                    return DataResult.success((Object)fallback);
                }
                return DataResult.error(() -> "No such enum constant " + s + " for class " + String.valueOf(clss));
            }
        }, e -> DataResult.success((Object)e.name()));
    }

    public static <T extends Enum<T>> Codec<T> ordinalEnumCodec(Class<T> clss, T fallback) {
        return Codec.INT.flatXmap(s -> {
            try {
                return DataResult.success((Object)((Enum[])clss.getEnumConstants())[s]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (fallback != null) {
                    return DataResult.success((Object)fallback);
                }
                return DataResult.error(() -> "No such enum ordinal " + s + " for class " + String.valueOf(clss));
            }
        }, e -> DataResult.success((Object)e.ordinal()));
    }

    private record TryCodec<F>(Codec<F> first, Codec<F> second) implements Codec<F>
    {
        public <T> DataResult<Pair<F, T>> decode(DynamicOps<T> ops, T input) {
            DataResult first = this.first.decode(ops, input);
            if (first.isSuccess()) {
                return first;
            }
            DataResult second = this.second.decode(ops, input);
            if (second.isSuccess()) {
                return second;
            }
            return first.apply2((f, s) -> s, second);
        }

        public <T> DataResult<T> encode(F input, DynamicOps<T> ops, T prefix) {
            DataResult first = this.first.encode(input, ops, prefix);
            if (first.isSuccess()) {
                return first;
            }
            DataResult second = this.second.encode(input, ops, prefix);
            if (second.isSuccess()) {
                return second;
            }
            return first.apply2((f, s) -> s, second);
        }
    }
}

