/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.item;

import io.github.flemmli97.tenshilib.common.item.ExtendedWeapon;
import io.github.flemmli97.tenshilib.common.utils.HitResultUtils;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import io.github.flemmli97.tenshilib.loader.event.AOEAttackHandler;
import io.github.flemmli97.tenshilib.mixinhelper.PlayerAttackAccess;
import java.util.ArrayList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;

public interface AOEWeapon
extends ExtendedWeapon {
    public static OrientedBoundingBox createOBB(LivingEntity entity, double length, double width, double height) {
        AABB aabb = new AABB(-width * 0.5, 0.0, 0.0, width * 0.5, height, length);
        float yRot = entity.getYHeadRot();
        float xRot = -entity.getXRot();
        return new OrientedBoundingBox(aabb.move(0.0, -aabb.getYsize() * 0.5, 0.0), yRot, xRot, entity.getEyePosition());
    }

    @Override
    default public void executeAttack(Player player, ItemStack stack) {
        ArrayList<Entity> list;
        if (player.level().isClientSide) {
            return;
        }
        OrientedBoundingBox obb = this.attackOBB((LivingEntity)player, stack, true);
        if (obb == null) {
            list = new ArrayList();
            EntityHitResult hit = HitResultUtils.calculateEntityFromLook((LivingEntity)player, this.getRange((LivingEntity)player, stack));
            if (hit != null) {
                list.add(hit.getEntity());
            }
        } else {
            list = HitResultUtils.getEntities((LivingEntity)player, obb, EntityTypeTest.forClass(Entity.class), null);
        }
        if (AOEAttackHandler.INSTANCE.trigger(player, stack, list) || list.isEmpty()) {
            return;
        }
        ((PlayerAttackAccess)player).tenshilib$SetNoSweeping(!this.doSweepingAttack());
        for (int i = 0; i < list.size(); ++i) {
            boolean resetCooldown = i == list.size() - 1;
            ((PlayerAttackAccess)player).tenshilib$SetNoStrengthResetState(!resetCooldown);
            player.attack((Entity)list.get(i));
        }
        ((PlayerAttackAccess)player).tenshilib$SetNoStrengthResetState(false);
        ((PlayerAttackAccess)player).tenshilib$SetNoSweeping(false);
    }

    default public OrientedBoundingBox attackOBB(LivingEntity entity, ItemStack stack, boolean debug) {
        double width = this.getWidth(entity, stack);
        double length = this.getRange(entity, stack);
        double height = 1.0;
        return AOEWeapon.createOBB(entity, width, length, height);
    }

    default public float getWidth(LivingEntity entity, ItemStack stack) {
        return 0.5f;
    }
}

