/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.animated;

import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;

public class AnimationState {
    private final AnimationDefinition data;
    private final double speed;
    private final double offset;
    private final int startTransition;
    private final int endTransition;
    private double ticker;

    private AnimationState(AnimationDefinition data, double speed, int startTransition, int endTransition, double offset) {
        this.data = data;
        this.speed = speed;
        this.startTransition = startTransition;
        this.endTransition = endTransition;
        this.offset = offset;
    }

    public static AnimationState create(AnimationDefinition data) {
        return AnimationState.create(data, 1.0);
    }

    public static AnimationState create(AnimationDefinition data, double speed) {
        return AnimationState.create(data, -1, -1, 0.0, speed);
    }

    public static AnimationState create(AnimationDefinition data, int startTransition, int endTransition, double offset, double speed) {
        AnimationState state = new AnimationState(data, data.speed() * speed, data.startTransition() > 0 && startTransition == -1 ? data.startTransition() : startTransition, data.endTransition() > 0 && endTransition == -1 ? data.endTransition() : endTransition, offset);
        state.ticker = offset;
        return state;
    }

    public AnimationDefinition definition() {
        return this.data;
    }

    public boolean tick() {
        return this.tick(1);
    }

    public boolean tick(int offset) {
        double d;
        this.ticker += this.speed;
        return d >= this.data.length() + (double)this.startTransition + (double)offset && this.data.shouldRunOut();
    }

    public boolean done(int offset) {
        return this.ticker >= this.data.length() + (double)this.startTransition + (double)offset;
    }

    public double getSpeed() {
        return this.speed;
    }

    public double progress(float partialTicks) {
        return this.progress(0.0, this.data.length(), partialTicks, 0);
    }

    public double progress(double start, double end, float partialTicks, int offset) {
        double tick = (double)this.getTick(partialTicks) + (double)offset * this.speed;
        double length = end - start;
        return Mth.clamp((double)((tick - start) / length), (double)0.0, (double)1.0);
    }

    public double getStartTransitionProgress(float partialTicks) {
        if (this.getStartTransition() <= 0) {
            return 1.0;
        }
        double tick = Math.max(0.0, this.ticker - this.offset - 1.0 + (double)partialTicks * this.speed);
        return Mth.clamp((double)(tick / (double)this.getStartTransition()), (double)0.0, (double)1.0);
    }

    public int getStartTransition() {
        return this.startTransition;
    }

    public int getEndTransitionTime() {
        return this.endTransition;
    }

    public float getTick(float partialTicks) {
        return (float)Math.max(this.offset, this.ticker - (double)this.startTransition - 1.0 + (double)partialTicks * this.speed);
    }

    public boolean isAt(double time) {
        return this.isAt(time, true);
    }

    public boolean isAt(double time, boolean seconds) {
        double tick = seconds ? time * 20.0 : time;
        double current = this.getTick(1.0f);
        double last = current - this.speed;
        return last < tick && current >= tick;
    }

    public boolean isPast(double time) {
        return this.isPast(time, true);
    }

    public boolean isPast(double time, boolean seconds) {
        double tick = seconds ? time * 20.0 : time;
        return (double)this.getTick(1.0f) >= tick;
    }

    public boolean isBetween(double start, double end) {
        return this.isBetween(start, end, true);
    }

    public boolean isBetween(double start, double end, boolean seconds) {
        double startTick = seconds ? start * 20.0 : start;
        double endTick = seconds ? end * 20.0 : end;
        double tick = this.getTick(1.0f);
        return tick >= startTick && tick <= endTick;
    }

    public boolean isAt(String marker) {
        double[] times = this.data.markers().get(marker);
        if (times == null) {
            return false;
        }
        for (double time : times) {
            if (!this.isAt(time)) continue;
            return true;
        }
        return false;
    }

    public boolean isPast(String marker) {
        return this.isPast(marker, -1.0);
    }

    public boolean isPast(String marker, double max) {
        double[] times = this.data.markers().get(marker);
        if (times == null) {
            return false;
        }
        for (double time : times) {
            boolean matches;
            boolean bl = matches = max >= 0.0 ? this.isBetween(time, max) : this.isPast(time);
            if (!matches) continue;
            return true;
        }
        return false;
    }

    public double getLength() {
        return this.data.length();
    }

    public void reset() {
        this.ticker = 0.0;
    }

    public String getID() {
        return this.data.id();
    }

    public String getAnimation() {
        return this.data.animation();
    }

    public double getMarker(String marker, int index) {
        double[] times = this.data.markers().get(marker);
        if (times == null || index >= times.length) {
            return -1.0;
        }
        return times[index];
    }

    public boolean is(AnimationState ... others) {
        for (AnimationState other : others) {
            if (other == null || !this.getID().equals(other.getID())) continue;
            return true;
        }
        return false;
    }

    public boolean is(AnimationDefinition ... definitions) {
        return this.data.is(definitions);
    }

    public boolean is(String ... ids) {
        return this.data.is(ids);
    }

    public boolean shouldRunOut() {
        return this.data.shouldRunOut();
    }

    public String toString() {
        return String.format("ID: %s, length: %s, speed: %s", this.getID(), this.getLength(), this.speed);
    }

    public boolean equals(Object o) {
        if (o instanceof AnimationState) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public SyncableState forSync() {
        return new SyncableState(this.data.id(), this.speed, this.startTransition, this.endTransition, this.offset);
    }

    public record SyncableState(String id, double speed, int startTransition, int endTransition, double offset) {
        public static final StreamCodec<FriendlyByteBuf, SyncableState> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, SyncableState>(){

            public SyncableState decode(FriendlyByteBuf buf) {
                return new SyncableState(buf.readUtf(), buf.readDouble(), buf.readInt(), buf.readInt(), buf.readDouble());
            }

            public void encode(FriendlyByteBuf buf, SyncableState state) {
                buf.writeUtf(state.id);
                buf.writeDouble(state.speed);
                buf.writeInt(state.startTransition);
                buf.writeInt(state.endTransition);
                buf.writeDouble(state.offset);
            }
        };

        public SyncableState withOffset(double offset) {
            return new SyncableState(this.id, this.speed, this.startTransition, this.endTransition, offset);
        }
    }
}

