/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai;

import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public record TargetPosition(Vec3 position, double minHeight, double maxHeight) {
    @Deprecated
    public static TargetPosition of(LivingEntity target) {
        return TargetPosition.reducedRangeOf(target);
    }

    public static TargetPosition reducedRangeOf(LivingEntity target) {
        double yRed = Mth.clamp((double)(target.getBbHeight() - target.getEyeHeight()), (double)0.0, (double)0.3);
        return TargetPosition.of(target, yRed);
    }

    public static TargetPosition fullRangeOf(LivingEntity target) {
        return TargetPosition.of(target, 0.0);
    }

    public static TargetPosition of(LivingEntity target, double heightMod) {
        Vec3 pos = target.position();
        return new TargetPosition(pos, pos.y() + heightMod, pos.y() + (double)target.getBbHeight() - heightMod);
    }

    public static TargetPosition of(Vec3 target) {
        return new TargetPosition(target, target.y(), target.y());
    }

    public Vec3 asVec(Vec3 from) {
        return EntityUtils.getStraightProjectileTarget(from, this.position, this.minHeight, this.maxHeight);
    }
}

