/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.phys.Vec3;

public class MoveControllerPlus
extends MoveControl {
    public MoveControllerPlus(Mob entity) {
        super(entity);
    }

    public void tick() {
        if (this.operation == MoveControl.Operation.STRAFE) {
            int z;
            int y;
            int x;
            float speed = (float)(this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED) * this.speedModifier);
            float forward = this.strafeForwards;
            float right = this.strafeRight;
            float len = Mth.sqrt((float)(forward * forward + right * right));
            if (len < 1.0f) {
                len = 1.0f;
            }
            len = speed / len;
            Vec3 target = new Vec3((double)(right *= len), 0.0, (double)(forward *= len)).normalize().scale((double)this.mob.getBbWidth() + 0.3).yRot(-this.mob.getYRot() * ((float)Math.PI / 180));
            PathNavigation pathnavigate = this.mob.getNavigation();
            PathfindingContext ctx = new PathfindingContext((CollisionGetter)this.mob.level(), this.mob);
            NodeEvaluator nodeprocessor = pathnavigate.getNodeEvaluator();
            PathType node = nodeprocessor.getPathType(ctx, x = Mth.floor((double)(this.mob.getX() + target.x())), y = Mth.floor((double)this.mob.getY()), z = Mth.floor((double)(this.mob.getZ() + target.z())));
            if (node == PathType.BLOCKED) {
                int yAdd = 0;
                while ((float)yAdd < this.mob.maxUpStep()) {
                    if ((node = nodeprocessor.getPathType(ctx, x, y + ++yAdd, z)) != PathType.WALKABLE) continue;
                    this.mob.getJumpControl().jump();
                    break;
                }
            } else if (node != PathType.WALKABLE) {
                this.strafeForwards = 1.0f;
                this.strafeRight = 0.0f;
            }
            this.mob.setSpeed(speed);
            this.mob.setZza(this.strafeForwards);
            this.mob.setXxa(this.strafeRight);
            this.operation = MoveControl.Operation.WAIT;
        } else {
            super.tick();
            this.mob.setXxa(0.0f);
        }
    }
}

