/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.flemmli97.tenshilib.client.ClientHandlers;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.phys.Vec3;

public class RiderEntityLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final EntityRenderDispatcher dispatcher;
    private final LivingEntityRenderer<T, M> renderer;

    public RiderEntityLayer(LivingEntityRenderer<T, M> renderer) {
        super(renderer);
        this.renderer = renderer;
        this.dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
    }

    public void render(PoseStack stack, MultiBufferSource buffer, int light, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        for (int i = 0; i < entity.getPassengers().size(); ++i) {
            Entity rider = (Entity)entity.getPassengers().get(i);
            if (rider == null || Minecraft.getInstance().cameraEntity == rider && Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON) continue;
            ClientHandlers.RIDING_RENDER_BLACKLIST.add(rider.getUUID());
            stack.pushPose();
            EntityRenderer entityRenderer = this.dispatcher.getRenderer(rider);
            boolean transformed = ((RideableModel)this.getParentModel()).transform(entity, this.renderer, rider, (EntityRenderer<?>)entityRenderer, stack, i);
            this.renderPassenger(entity, entityRenderer, rider, partialTicks, stack, buffer, light, transformed);
            stack.popPose();
            ClientHandlers.RIDING_RENDER_BLACKLIST.remove(rider.getUUID());
        }
    }

    protected void undoLivingRendererTransform(EntityRenderer<?> entityRenderer, PoseStack stack, T entity, Entity rider, float partialTicks, boolean transformed) {
        float yaw = Mth.rotLerp((float)partialTicks, (float)((LivingEntity)entity).yBodyRotO, (float)((LivingEntity)entity).yBodyRot);
        if (rider instanceof LivingEntity) {
            LivingEntity livingRider = (LivingEntity)rider;
            float headRot = Mth.rotLerp((float)partialTicks, (float)livingRider.yHeadRotO, (float)livingRider.yHeadRot);
            float diff = Mth.wrapDegrees((float)(headRot - yaw));
            if (diff < -85.0f) {
                diff = -85.0f;
            }
            if (diff >= 85.0f) {
                diff = 85.0f;
            }
            yaw = headRot - diff;
            if (diff * diff > 2500.0f) {
                yaw += diff * 0.2f;
            }
        }
        if (!transformed) {
            stack.translate(0.0, (double)1.501f, 0.0);
        }
        stack.scale(-1.0f, -1.0f, 1.0f);
        stack.mulPose(Axis.YP.rotationDegrees(yaw + 180.0f));
    }

    public <E extends Entity> void renderPassenger(T vehicle, EntityRenderer<E> entityRenderer, E entity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight, boolean transformed) {
        try {
            this.undoLivingRendererTransform(entityRenderer, stack, vehicle, entity, partialTicks, transformed);
            if (!transformed) {
                Vec3 diff = entity.position().subtract(vehicle.position());
                stack.translate(diff.x, diff.y, diff.z);
            }
            entityRenderer.render(entity, 0.0f, partialTicks, stack, buffer, packedLight);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)throwable, (String)("Rendering entity in level from " + String.valueOf(((Object)((Object)this)).getClass())));
            CrashReportCategory crashReportCategory = crashReport.addCategory("Entity being rendered");
            entity.fillCrashReportCategory(crashReportCategory);
            CrashReportCategory crashReportCategory2 = crashReport.addCategory("Renderer details");
            crashReportCategory2.setDetail("Assigned renderer", entityRenderer);
            crashReportCategory2.setDetail("Location", (Object)CrashReportCategory.formatLocation((LevelHeightAccessor)entity.level(), (double)entity.position().x, (double)entity.position().y, (double)entity.position().z));
            crashReportCategory2.setDetail("Delta", (Object)Float.valueOf(partialTicks));
            throw new ReportedException(crashReport);
        }
    }
}

