/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public abstract class SimpleModelRenderer<T extends Entity>
extends EntityRenderer<T> {
    protected final EntityModel<T> model;
    protected float red = 1.0f;
    protected float green = 1.0f;
    protected float blue = 1.0f;
    protected float alpha = 1.0f;

    public SimpleModelRenderer(EntityRendererProvider.Context ctx, EntityModel<T> model) {
        super(ctx);
        this.model = model;
    }

    public void render(T entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.pushPose();
        float yaw = Mth.lerp((float)partialTicks, (float)((Entity)entity).yRotO, (float)entity.getYRot()) + this.yawOffset();
        float pitch = Mth.lerp((float)partialTicks, (float)((Entity)entity).xRotO, (float)entity.getXRot()) + this.pitchOffset();
        float partialLivingTicks = (float)((Entity)entity).tickCount + partialTicks;
        this.translate(entity, stack, pitch, yaw, partialTicks);
        this.model.prepareMobModel(entity, 0.0f, 0.0f, partialTicks);
        this.model.setupAnim(entity, 0.0f, 0.0f, partialLivingTicks, yaw, pitch);
        VertexConsumer ivertexbuilder = buffer.getBuffer(this.model.renderType(this.getTextureLocation((Entity)entity)));
        this.model.renderToBuffer(stack, ivertexbuilder, packedLight, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.colorFromFloat((float)this.red, (float)this.green, (float)this.blue, (float)this.alpha));
        this.afterModelRender(entity, rotation, partialTicks, stack, buffer, packedLight);
        stack.popPose();
        super.render(entity, rotation, partialTicks, stack, buffer, packedLight);
    }

    public void translate(T entity, PoseStack stack, float pitch, float yaw, float partialTicks) {
        stack.mulPose(Axis.YP.rotationDegrees(180.0f + yaw));
        stack.mulPose(Axis.XP.rotationDegrees(pitch));
        stack.scale(-1.0f, -1.0f, 1.0f);
        stack.translate(0.0, (double)-1.501f, 0.0);
    }

    public float yawOffset() {
        return 0.0f;
    }

    public float pitchOffset() {
        return 0.0f;
    }

    public void afterModelRender(T entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
    }
}

