/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.data;

import com.google.gson.JsonElement;
import io.github.flemmli97.tenshilib.TenshiLib;
import io.github.flemmli97.tenshilib.client.data.ModelCache;
import io.github.flemmli97.tenshilib.client.data.ReloadableCache;
import io.github.flemmli97.tenshilib.client.model.BedrockGeometryParser;
import io.github.flemmli97.tenshilib.client.model.DeformationChange;
import io.github.flemmli97.tenshilib.client.model.ModelPartsContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class GeoModelManager
extends SimpleJsonResourceReloadListener {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"tenshilib", (String)"models");
    public static final String DIRECTORY = String.format("%s/%s", ID.getNamespace(), ID.getPath());
    private static final GeoModelManager INSTANCE = new GeoModelManager();
    private final Map<ResourceLocation, ModelCache> models = new HashMap<ResourceLocation, ModelCache>();
    private boolean reloaded;

    private GeoModelManager() {
        super(BedrockGeometryParser.GSON, DIRECTORY);
    }

    public static GeoModelManager getInstance() {
        return INSTANCE;
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller profiler) {
        HashSet present = new HashSet();
        map.forEach((res, json) -> {
            try {
                BedrockGeometryParser.BedrockGeometry read = (BedrockGeometryParser.BedrockGeometry)BedrockGeometryParser.GSON.fromJson(json, BedrockGeometryParser.BedrockGeometry.class);
                ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)res.getNamespace(), (String)res.getPath().replace(".geo", ""));
                this.getUnbaked(id).update(read);
                present.add(id);
            }
            catch (Exception e) {
                TenshiLib.LOGGER.error("Unable to parse geo model file {}", res, (Object)e);
            }
        });
        this.reloaded = true;
        ArrayList missing = new ArrayList();
        this.models.keySet().forEach(id -> {
            if (!present.contains(id)) {
                missing.add(id);
            }
        });
        if (!missing.isEmpty()) {
            throw new IllegalStateException("Following models could not be found! " + String.valueOf(missing));
        }
    }

    private ModelCache getUnbaked(ResourceLocation id) {
        return this.models.computeIfAbsent(id, r -> {
            if (this.reloaded) {
                TenshiLib.LOGGER.error("Model {} is not present! Returned result will be empty!", r);
            }
            return new ModelCache();
        });
    }

    public ReloadableCache<ModelPartsContainer> getModel(ResourceLocation id) {
        return this.getModel(id, null);
    }

    public ReloadableCache<ModelPartsContainer> getModel(ResourceLocation id, Consumer<ModelPartsContainer> onChange) {
        return this.getModel(id, DeformationChange.NONE, onChange);
    }

    public ReloadableCache<ModelPartsContainer> getModel(ResourceLocation id, DeformationChange deformation, Consumer<ModelPartsContainer> onChange) {
        return this.getUnbaked(id).bake(deformation, onChange);
    }
}

