/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbjeiextras.geneticsresequenced.recipes;

import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.PlasmidItem;
import dev.aaronhowser.mods.geneticsresequenced.item.SyringeItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.ftb.mods.ftbjeiextras.modspecific.GeneticsHelpers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class PlasmidInjectorRecipe {
    private final Ingredient plasmid;
    private final Ingredient syringeBefore;
    private final ItemStack syringeAfter;

    public PlasmidInjectorRecipe(Holder<Gene> geneHolder, boolean isMetal, boolean isAntiPlasmid) {
        ItemStack plasmidStack = isAntiPlasmid ? ModItems.INSTANCE.getANTI_PLASMID().toStack() : ModItems.INSTANCE.getPLASMID().toStack();
        PlasmidItem.Companion.setGene(plasmidStack, geneHolder, ((Gene)geneHolder.value()).getDnaPointsRequired());
        this.plasmid = Ingredient.of((ItemStack[])new ItemStack[]{plasmidStack});
        ItemStack syringeStack = isMetal ? ModItems.INSTANCE.getMETAL_SYRINGE().toStack() : ModItems.INSTANCE.getSYRINGE().toStack();
        LivingEntity entity = GeneticsHelpers.createLivingEntity(isMetal);
        SyringeItem.Companion.setEntity(syringeStack, entity, false);
        this.syringeBefore = Ingredient.of((ItemStack[])new ItemStack[]{syringeStack});
        if (isAntiPlasmid) {
            SyringeItem.Companion.addAntigene(syringeStack, geneHolder);
        } else {
            SyringeItem.Companion.addGene(syringeStack, geneHolder);
        }
        this.syringeAfter = syringeStack;
    }

    public Ingredient getPlasmid() {
        return this.plasmid;
    }

    public Ingredient getSyringeBefore() {
        return this.syringeBefore;
    }

    public ItemStack getSyringeAfter() {
        return this.syringeAfter;
    }

    public static List<PlasmidInjectorRecipe> collectAllRecipes(RegistryAccess registryAccess) {
        ArrayList<PlasmidInjectorRecipe> recipes = new ArrayList<PlasmidInjectorRecipe>();
        for (Holder geneHolder : ModGenes.INSTANCE.getRegistrySorted((HolderLookup.Provider)registryAccess, true, false)) {
            recipes.add(new PlasmidInjectorRecipe((Holder<Gene>)geneHolder, false, false));
            recipes.add(new PlasmidInjectorRecipe((Holder<Gene>)geneHolder, true, false));
            recipes.add(new PlasmidInjectorRecipe((Holder<Gene>)geneHolder, false, true));
            recipes.add(new PlasmidInjectorRecipe((Holder<Gene>)geneHolder, true, true));
        }
        return recipes;
    }
}

