/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.mixin.errorable;

import com.bawnorton.neruina.extend.Errorable;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockEntity.class})
abstract class BlockEntityMixin
implements Errorable {
    @Unique
    private boolean neruina$errored = false;
    @Unique
    private UUID neruina$tickingEntryId = null;

    BlockEntityMixin() {
    }

    @Override
    public boolean neruina$isErrored() {
        return this.neruina$errored;
    }

    @Override
    public void neruina$setErrored() {
        this.neruina$errored = true;
    }

    @Override
    public void neruina$clearErrored() {
        this.neruina$errored = false;
    }

    @Override
    public void neruina$setTickingEntryId(UUID uuid) {
        this.neruina$tickingEntryId = uuid;
    }

    @Override
    public UUID neruina$getTickingEntryId() {
        return this.neruina$tickingEntryId;
    }

    @Inject(method={"saveAdditional"}, at={@At(value="HEAD")})
    private void writeErrored(CompoundTag tag, HolderLookup.Provider registries, CallbackInfo ci) {
        if (this.neruina$errored) {
            tag.putBoolean("neruina$errored", true);
        }
        if (this.neruina$tickingEntryId != null) {
            tag.putString("neruina$tickingEntryId", this.neruina$tickingEntryId.toString());
        }
    }

    @Inject(method={"loadAdditional"}, at={@At(value="TAIL")})
    private void loadAdditional(CompoundTag tag, HolderLookup.Provider registries, CallbackInfo ci) {
        this.neruina$errored = tag.getBoolean("neruina$errored");
        if (tag.contains("neruina$tickingEntryId")) {
            this.neruina$tickingEntryId = UUID.fromString(tag.getString("neruina$tickingEntryId"));
        }
    }
}

