/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.handler;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.config.Config;
import com.bawnorton.neruina.handler.TickHandler;
import com.bawnorton.neruina.thread.ConditionalRunnable;
import com.bawnorton.neruina.util.ErroredType;
import com.bawnorton.neruina.util.TickingEntry;
import com.bawnorton.neruina.version.PermissionWrapper;
import com.bawnorton.neruina.version.Texter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class MessageHandler {
    public void broadcastToPlayers(MinecraftServer server, Component message, ActionGetter getter) {
        ConditionalRunnable.create(() -> {
            int permissionLevel = Config.minPermissionLevelForMessages;
            if (permissionLevel < 0) {
                return;
            }
            server.getPlayerList().getPlayers().stream().filter(player -> PermissionWrapper.hasPermission((Player)player, permissionLevel)).forEach(player -> {
                Component actions = getter.get((Player)player);
                player.sendSystemMessage(Texter.pad(Texter.concatDelimited(Texter.LINE_BREAK, message, actions)), false);
            });
        }, () -> server.getPlayerList().getPlayerCount() > 0);
    }

    public void broadcastToPlayers(MinecraftServer server, Component message) {
        this.broadcastToPlayers(server, message, p -> Texter.empty());
    }

    public void sendToPlayer(Player player, Component message, Component ... actions) {
        this.sendToPlayer(player, message, true, actions);
    }

    public void sendToPlayer(Player player, Component message, boolean pad, Component ... actions) {
        message = Texter.concatDelimited(Texter.LINE_BREAK, Texter.format(message), actions != null ? Texter.concatDelimited(Texter.LINE_BREAK, actions) : null);
        player.displayClientMessage(pad ? Texter.pad(message) : message, false);
    }

    public Component generateEntityActions(Player forPlayer, Entity entity) {
        return Texter.concatDelimited(Texter.SPACE, this.generateHandlingActions(forPlayer, ErroredType.ENTITY, (ResourceKey<Level>)entity.level().dimension(), entity.getOnPos(), entity.getUUID()), this.generateKillAction(forPlayer, entity.getUUID()));
    }

    public Component generateResourceActions(Player forPlayer, TickingEntry entry) {
        return Texter.concatDelimited(Texter.SPACE, this.generateInfoAction(), this.generateCopyCrashAction(entry), this.generateReportAction(forPlayer, entry));
    }

    public Component generateHandlingActions(Player forPlayer, ErroredType type, ResourceKey<Level> dimension, BlockPos pos) {
        return this.generateHandlingActions(forPlayer, type, dimension, pos, null);
    }

    public Component generateHandlingActions(Player forPlayer, ErroredType type, ResourceKey<Level> dimension, BlockPos pos, @Nullable UUID uuid) {
        return Texter.concatDelimited(Texter.SPACE, this.generateTeleportAction(forPlayer, type, dimension, pos), this.generateResumeAction(forPlayer, type, uuid != null ? uuid.toString() : this.posAsNums(pos)));
    }

    public Component generateKillAction(Player forPlayer, UUID uuid) {
        return this.generateCommandAction(forPlayer, "neruina.kill", ChatFormatting.DARK_RED, "/neruina kill %s".formatted(uuid));
    }

    public Component generateCopyCrashAction(TickingEntry entry) {
        StringWriter traceString = new StringWriter();
        PrintWriter writer = new PrintWriter(traceString);
        entry.error().printStackTrace(writer);
        String trace = traceString.toString();
        writer.flush();
        writer.close();
        return this.generateAction("neruina.copy_crash", ChatFormatting.GOLD, ClickEvent.Action.COPY_TO_CLIPBOARD, trace);
    }

    public Component generateReportAction(Player forPlayer, TickingEntry entry) {
        return this.generateCommandAction(forPlayer, "neruina.report", ChatFormatting.LIGHT_PURPLE, "/neruina report %s".formatted(entry.uuid()));
    }

    public Component generateTeleportAction(Player forPlayer, ErroredType type, ResourceKey<Level> dimension, BlockPos pos) {
        return this.generateCommandAction(forPlayer, "neruina.teleport", "neruina.teleport.%s.tooltip".formatted(type.getName()), ChatFormatting.DARK_AQUA, "/execute in %s run tp @s %s".formatted(dimension.location().toString(), this.posAsNums(pos)));
    }

    public Component generateInfoAction() {
        return this.generateAction("neruina.info", ChatFormatting.GREEN, ClickEvent.Action.OPEN_URL, "https://github.com/Bawnorton/Neruina/wiki/What-Is-This%3F");
    }

    public Component generateResumeAction(Player forPlayer, ErroredType type, String args) {
        return this.generateCommandAction(forPlayer, "neruina.try_resume", "neruina.try_resume.%s.tooltip".formatted(type.getName()), ChatFormatting.YELLOW, "/neruina resume %s %s".formatted(type.getName(), args));
    }

    public Component generateClearAction(Player forPlayer) {
        return this.generateCommandAction(forPlayer, "neruina.clear", ChatFormatting.BLUE, "/neruina clear_tracked");
    }

    public Component generateOpenReportAction(String url) {
        return this.generateAction("neruina.open_report", ChatFormatting.LIGHT_PURPLE, ClickEvent.Action.OPEN_URL, url);
    }

    public Component generateCancelLoginAction(Player forPlayer) {
        return this.generateCommandAction(forPlayer, "neruina.cancel", ChatFormatting.DARK_RED, "/neruina cancel_login");
    }

    private Component generateCommandAction(Player forPlayer, String key, ChatFormatting color, String command) {
        return this.generateCommandAction(forPlayer, key, "%s.tooltip".formatted(key), color, command);
    }

    private Component generateCommandAction(Player forPlayer, String key, String hoverKey, ChatFormatting color, String command) {
        if (PermissionWrapper.hasPermission(forPlayer, (int)Config.minPermissionLevelForCommands)) {
            return this.generateAction(key, hoverKey, color, ClickEvent.Action.RUN_COMMAND, command);
        }
        return Texter.empty();
    }

    private Component generateCommandAction(Player forPlayer, Component message, String hoverKey, ChatFormatting color, String command) {
        return this.generateCommandAction(forPlayer, message, Texter.translatable(hoverKey, new Object[0]), color, command);
    }

    private Component generateCommandAction(Player forPlayer, Component message, Component hoverMessage, ChatFormatting color, String command) {
        if (PermissionWrapper.hasPermission(forPlayer, (int)Config.minPermissionLevelForCommands)) {
            return this.generateAction(message, hoverMessage, color, ClickEvent.Action.RUN_COMMAND, command);
        }
        return Texter.empty();
    }

    private Component generateAction(String key, ChatFormatting color, ClickEvent.Action action, String value) {
        return this.generateAction(key, "%s.tooltip".formatted(key), color, action, value);
    }

    private Component generateAction(String key, String hoverKey, ChatFormatting color, ClickEvent.Action action, String value) {
        return this.generateAction(Texter.translatable(key, new Object[0]), Texter.translatable(hoverKey, new Object[0]), color, action, value);
    }

    private Component generateAction(Component message, Component hoverMessage, ChatFormatting color, ClickEvent.Action action, String value) {
        return ComponentUtils.wrapInSquareBrackets((Component)Texter.withStyle(message, style -> style.withColor(color).withClickEvent(Texter.clickEvent(action, value)).withHoverEvent(Texter.hoverEvent(HoverEvent.Action.SHOW_TEXT, hoverMessage))));
    }

    public Component generateSuspendedInfo(Player forPlayer) {
        TickHandler tickHandler = Neruina.getInstance().getTickHandler();
        ArrayList<Component> tickingEntryMessages = new ArrayList<Component>();
        int count = tickHandler.getTickingEntries().size();
        if (count == 1) {
            tickingEntryMessages.add(this.formatText("neruina.ticking_entries.count.single", new Object[0]));
        } else {
            tickingEntryMessages.add(this.formatText("neruina.ticking_entries.count", count));
        }
        tickHandler.getTickingEntries().forEach(entry -> tickingEntryMessages.add(this.generateCommandAction(forPlayer, Texter.translatable("neruina.ticking_entries.entry", entry.getCauseName(), this.posAsNums(entry.pos())), "neruina.ticking_entries.entry.tooltip", ChatFormatting.DARK_RED, "/neruina info %s".formatted(entry.uuid()))));
        tickingEntryMessages.add(Texter.concatDelimited(Texter.SPACE, this.generateInfoAction(), this.generateClearAction(forPlayer)));
        return Texter.concatDelimited(Texter.LINE_BREAK, tickingEntryMessages.toArray(new Component[0]));
    }

    public Component formatText(String key, Object ... args) {
        return Texter.format(Texter.translatable(key, args));
    }

    public String posAsNums(BlockPos pos) {
        return "%s %s %s".formatted(pos.getX(), pos.getY(), pos.getZ());
    }

    public static interface ActionGetter {
        public Component get(Player var1);
    }
}

