/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.logic.entityblocking.megatorch;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.xalcon.torchmaster.ModRegistry;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.logic.IDistanceLogic;
import net.xalcon.torchmaster.logic.entityblocking.IEntityBlockingLight;
import net.xalcon.torchmaster.platform.Services;

public class MegatorchEntityBlockingLight
implements IEntityBlockingLight {
    public static final VoxelShape SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private BlockPos pos;

    public MegatorchEntityBlockingLight(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public boolean shouldBlockEntityType(EntityType<?> entityType, Level level, Vec3 pos, MobSpawnType spawnType) {
        return Torchmaster.MegaTorchFilterRegistry.containsEntity(EntityType.getKey(entityType)) && IDistanceLogic.Cubic.isPositionInRange(pos.x, pos.y, pos.z, this.pos, Services.PLATFORM.getConfig().getMegaTorchRadius());
    }

    @Override
    public boolean shouldBlockVillageZombieRaid(Vec3 pos) {
        return IDistanceLogic.Cubic.isPositionInRange(pos.x(), pos.y(), pos.z(), this.pos, Services.PLATFORM.getConfig().getMegaTorchRadius());
    }

    @Override
    public String getLightSerializerType() {
        return "megatorch";
    }

    @Override
    public boolean cleanupCheck(Level level) {
        return level.isLoaded(this.pos) && level.getBlockState(this.pos).getBlock() != ModRegistry.blockMegaTorch.get();
    }

    @Override
    public String getDisplayName() {
        return "Mega Torch";
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }
}

