/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.common.entities;

import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import tallestegg.guardvillagers.GuardVillagers;
import tallestegg.guardvillagers.common.entities.Guard;

public class GuardContainer
extends AbstractContainerMenu {
    private final Container guardInventory;
    private final Guard guard;

    public GuardContainer(int id, final Inventory playerInventory, Container guardInventory, final Guard guard) {
        super(null, id);
        this.guardInventory = guardInventory;
        this.guard = guard;
        guardInventory.startOpen(playerInventory.player);
        this.addSlot(new Slot(this, guardInventory, 0, 8, 8){

            public boolean mayPlace(ItemStack stack) {
                return stack.canEquip(EquipmentSlot.HEAD, (LivingEntity)guard) && GuardVillagers.hotvChecker(playerInventory.player, guard);
            }

            public int getMaxStackSize() {
                return 1;
            }

            public void set(ItemStack stack) {
                super.set(stack);
                guard.setItemSlot(EquipmentSlot.HEAD, stack);
            }

            public boolean mayPickup(Player playerIn) {
                return GuardVillagers.hotvChecker(playerInventory.player, guard);
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_HELMET);
            }
        });
        this.addSlot(new Slot(this, guardInventory, 1, 8, 26){

            public boolean mayPlace(ItemStack stack) {
                return stack.canEquip(EquipmentSlot.CHEST, (LivingEntity)guard) && GuardVillagers.hotvChecker(playerInventory.player, guard);
            }

            public int getMaxStackSize() {
                return 1;
            }

            public void set(ItemStack stack) {
                super.set(stack);
                guard.setItemSlot(EquipmentSlot.CHEST, stack);
            }

            public boolean mayPickup(Player playerIn) {
                return GuardVillagers.hotvChecker(playerInventory.player, guard);
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE);
            }
        });
        this.addSlot(new Slot(this, guardInventory, 2, 8, 44){

            public boolean mayPlace(ItemStack stack) {
                return stack.canEquip(EquipmentSlot.LEGS, (LivingEntity)guard) && GuardVillagers.hotvChecker(playerInventory.player, guard);
            }

            public int getMaxStackSize() {
                return 1;
            }

            public void set(ItemStack stack) {
                super.set(stack);
                guard.setItemSlot(EquipmentSlot.LEGS, stack);
            }

            public boolean mayPickup(Player playerIn) {
                return GuardVillagers.hotvChecker(playerInventory.player, guard);
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS);
            }
        });
        this.addSlot(new Slot(this, guardInventory, 3, 8, 62){

            public boolean mayPlace(ItemStack stack) {
                return stack.canEquip(EquipmentSlot.FEET, (LivingEntity)guard) && GuardVillagers.hotvChecker(playerInventory.player, guard);
            }

            public int getMaxStackSize() {
                return 1;
            }

            public void set(ItemStack stack) {
                super.set(stack);
                guard.setItemSlot(EquipmentSlot.FEET, stack);
            }

            public boolean mayPickup(Player playerIn) {
                return GuardVillagers.hotvChecker(playerInventory.player, guard);
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS);
            }
        });
        this.addSlot(new Slot(this, guardInventory, 4, 77, 62){

            public boolean mayPlace(ItemStack stack) {
                return GuardVillagers.hotvChecker(playerInventory.player, guard);
            }

            public void set(ItemStack stack) {
                super.set(stack);
                guard.setItemSlot(EquipmentSlot.OFFHAND, stack);
            }

            public boolean mayPickup(Player playerIn) {
                return GuardVillagers.hotvChecker(playerInventory.player, guard);
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
        this.addSlot(new Slot(this, guardInventory, 5, 77, 44){

            public boolean mayPlace(ItemStack stack) {
                return GuardVillagers.hotvChecker(playerInventory.player, guard);
            }

            public boolean mayPickup(Player playerIn) {
                return GuardVillagers.hotvChecker(playerIn, guard);
            }

            public void set(ItemStack stack) {
                super.set(stack);
                guard.setItemSlot(EquipmentSlot.MAINHAND, stack);
            }
        });
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlot(new Slot((Container)playerInventory, j1 + (l + 1) * 9, 8 + j1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new Slot((Container)playerInventory, i1, 8 + i1 * 18, 142));
        }
    }

    public boolean stillValid(Player playerIn) {
        return this.guardInventory.stillValid(playerIn) && this.guard.isAlive() && this.guard.distanceTo((Entity)playerIn) < 8.0f;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            int i = this.guardInventory.getContainerSize();
            if (index < i) {
                if (!this.moveItemStackTo(itemstack1, i, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(1).mayPlace(itemstack1) && !this.getSlot(1).hasItem()) {
                if (!this.moveItemStackTo(itemstack1, 1, 2, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(0).mayPlace(itemstack1)) {
                if (!this.moveItemStackTo(itemstack1, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (i <= 2 || !this.moveItemStackTo(itemstack1, 2, i, false)) {
                int j = i + 27;
                int k = j + 9;
                if (index >= j && index < k ? !this.moveItemStackTo(itemstack1, i, j, false) : (index >= i && index < j ? !this.moveItemStackTo(itemstack1, j, k, false) : !this.moveItemStackTo(itemstack1, j, j, false))) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        this.guardInventory.stopOpen(playerIn);
        this.guard.interacting = false;
    }
}

