/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrialforegoingsouls.block.tile;

import com.buuz135.industrial.block.resourceproduction.tile.ILaserBase;
import com.buuz135.industrial.block.tile.IndustrialMachineTile;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrialforegoingsouls.IndustrialForegoingSouls;
import com.buuz135.industrialforegoingsouls.client.SculkSoulTankScreenAddon;
import com.buuz135.industrialforegoingsouls.config.ConfigSoulLaserBase;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.augment.AugmentTypes;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SoulLaserBaseBlockEntity
extends IndustrialMachineTile<SoulLaserBaseBlockEntity>
implements ILaserBase<SoulLaserBaseBlockEntity> {
    @Save
    private final ProgressBarComponent<SoulLaserBaseBlockEntity> work;
    @Save
    private final SidedInventoryComponent<SoulLaserBaseBlockEntity> catalyst;
    @Save
    private int soulAmount = 0;
    private boolean unloaded;

    public SoulLaserBaseBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(IndustrialForegoingSouls.SOUL_LASER_BLOCK, blockPos, blockState);
        this.setShowEnergy(false);
        this.work = new ProgressBarComponent<SoulLaserBaseBlockEntity>(74, 42, 0, ConfigSoulLaserBase.MAX_PROGRESS){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon<SoulLaserBaseBlockEntity>(SoulLaserBaseBlockEntity.this.work.getPosX(), SoulLaserBaseBlockEntity.this.work.getPosY(), (ProgressBarComponent)this){

                    public List<Component> getTooltipLines() {
                        ArrayList<Component> tooltip = new ArrayList<Component>();
                        tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GOLD) + Component.translatable((String)"tooltip.titanium.progressbar.progress").getString() + String.valueOf(ChatFormatting.WHITE) + new DecimalFormat().format(SoulLaserBaseBlockEntity.this.work.getProgress()) + String.valueOf(ChatFormatting.GOLD) + "/" + String.valueOf(ChatFormatting.WHITE) + new DecimalFormat().format(SoulLaserBaseBlockEntity.this.work.getMaxProgress()))));
                        return tooltip;
                    }
                });
            }
        }.setBarDirection(ProgressBarComponent.BarDirection.ARROW_RIGHT).setCanIncrease(oreLaserBaseTile -> true).setProgressIncrease(0).setCanReset(oreLaserBaseTile -> true).setOnStart(() -> {}).setOnFinishWork(this::onWork);
        this.addProgressBar(this.work);
        this.catalyst = (SidedInventoryComponent)new SidedInventoryComponent("lens", 50, 42, 1, 0).setColor(DyeColor.BLUE).setRange(2, 3).setSlotToItemStackRender(0, new ItemStack((ItemLike)ModuleCore.LASER_LENS[11].get())).setSlotLimit(1);
        this.addInventory((InventoryComponent)this.catalyst);
        this.catalyst.getFacingModes().keySet().forEach(sideness -> this.catalyst.getFacingModes().put(sideness, IFacingComponent.FaceMode.NONE));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new SculkSoulTankScreenAddon(100, 20, this));
    }

    public void setChanged() {
        super.setChanged();
    }

    private void onWork() {
        LivingEntity first;
        VoxelShape box;
        List entities;
        if (!this.catalyst.getStackInSlot(0).isEmpty() && this.catalyst.getStackInSlot(0).getItem().equals(ModuleCore.LASER_LENS[11].get()) && this.soulAmount < ConfigSoulLaserBase.SOUL_STORAGE_AMOUNT && (entities = this.level.getEntitiesOfClass(LivingEntity.class, (box = Shapes.box((double)-1.0, (double)0.0, (double)-1.0, (double)2.0, (double)3.0, (double)2.0).move((double)this.worldPosition.getX(), (double)(this.worldPosition.getY() - 1), (double)this.worldPosition.getZ())).bounds(), entity -> entity.getType().equals(EntityType.WARDEN) || entity.getType().is(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"wardens"))))).size() > 0 && ((first = (LivingEntity)entities.get(0)).getHealth() > (float)ConfigSoulLaserBase.DAMAGE_PER_OPERATION || ConfigSoulLaserBase.KILL_WARDEN)) {
            first.hurt(first.damageSources().generic(), (float)ConfigSoulLaserBase.DAMAGE_PER_OPERATION);
            this.soulAmount = Math.min(ConfigSoulLaserBase.SOUL_STORAGE_AMOUNT, this.soulAmount + ConfigSoulLaserBase.SOULS_PER_OPERATION);
            this.syncObject(this.soulAmount);
        }
        int maxProgress = (int)Math.floor((float)ConfigSoulLaserBase.MAX_PROGRESS * (this.hasAugmentInstalled(AugmentTypes.EFFICIENCY) ? AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(AugmentTypes.EFFICIENCY).get(0)), (IAugmentType)AugmentTypes.EFFICIENCY) : 1.0f));
        this.work.setMaxProgress(maxProgress);
    }

    public void clientTick(Level level, BlockPos pos, BlockState state, SoulLaserBaseBlockEntity blockEntity) {
        super.clientTick(level, pos, state, (IndustrialMachineTile)blockEntity);
        VoxelShape box = Shapes.box((double)-1.0, (double)0.0, (double)-1.0, (double)2.0, (double)3.0, (double)2.0).move((double)this.worldPosition.getX(), (double)(this.worldPosition.getY() - 1), (double)this.worldPosition.getZ());
        List entities = this.level.getEntitiesOfClass(Mob.class, box.bounds());
        for (Mob entity : entities) {
            if (!(entity instanceof Warden)) continue;
            Warden warden = (Warden)entity;
            warden.sonicBoomAnimationState.start(warden.tickCount - 43);
            if (!(level.random.nextDouble() <= (double)0.1f)) continue;
            level.addParticle((ParticleOptions)ParticleTypes.SCULK_SOUL, entity.getX() + (level.random.nextDouble() - 0.5), entity.getY() + 1.5, entity.getZ() + (level.random.nextDouble() - 0.5), 0.0, 0.1, 0.0);
        }
    }

    public int getSoulAmount() {
        return this.soulAmount;
    }

    public int useSoul(int soulAmount) {
        int oldAmount = this.soulAmount;
        this.soulAmount = Math.max(0, this.soulAmount - soulAmount);
        this.syncObject(this.soulAmount);
        return oldAmount - this.soulAmount;
    }

    public SoulLaserBaseBlockEntity getSelf() {
        return this;
    }

    protected EnergyStorageComponent<SoulLaserBaseBlockEntity> createEnergyStorage() {
        return new EnergyStorageComponent(0, 4, 10);
    }

    public ProgressBarComponent<SoulLaserBaseBlockEntity> getBar() {
        return this.work;
    }

    public boolean canAcceptAugment(ItemStack augment) {
        if (AugmentWrapper.hasType((ItemStack)augment, (IAugmentType)AugmentTypes.SPEED)) {
            return false;
        }
        return super.canAcceptAugment(augment);
    }
}

