/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.datagen;

import com.benbenlaw.strainers.fluid.StrainersFluids;
import com.benbenlaw.strainers.item.ModItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.loaders.DynamicFluidContainerModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

public class StrainersItemModelProvider
extends ItemModelProvider {
    public StrainersItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "strainers", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleBucketItem("purifying_water_bucket", StrainersFluids.PURIFYING_WATER.getFluid());
        this.simpleBucketItem("eroding_water_bucket", StrainersFluids.ERODING_WATER.getFluid());
        this.simpleItem(ModItems.STONE_PEBBLE);
        this.simpleItem(ModItems.PURIFYING_SALT_MULCH);
        this.simpleItem(ModItems.ERODING_SALT_MULCH);
        this.simpleItem(ModItems.BLAZING_SALT_MULCH);
        this.simpleItem(ModItems.LEAF_PILE);
        this.simpleItem(ModItems.SPEED_UPGRADE_1);
        this.simpleItem(ModItems.SPEED_UPGRADE_2);
        this.simpleItem(ModItems.SPEED_UPGRADE_3);
        this.simpleItem(ModItems.CHANCE_UPGRADE_1);
        this.simpleItem(ModItems.CHANCE_UPGRADE_2);
        this.simpleItem(ModItems.CHANCE_UPGRADE_3);
        this.simpleItem(ModItems.WOODEN_MESH);
        this.simpleItem(ModItems.BAMBOO_MESH);
        this.simpleItem(ModItems.STRING_MESH);
        this.simpleItem(ModItems.BONE_MESH);
        this.simpleItem(ModItems.FLINT_MESH);
        this.simpleItem(ModItems.COPPER_MESH);
        this.simpleItem(ModItems.LAPIS_MESH);
        this.simpleItem(ModItems.TIN_MESH);
        this.simpleItem(ModItems.IRON_MESH);
        this.simpleItem(ModItems.AMETHYST_MESH);
        this.simpleItem(ModItems.BRONZE_MESH);
        this.simpleItem(ModItems.REDSTONE_MESH);
        this.simpleItem(ModItems.GOLD_MESH);
        this.simpleItem(ModItems.QUARTZ_MESH);
        this.simpleItem(ModItems.BLAZE_MESH);
        this.simpleItem(ModItems.BREEZE_MESH);
        this.simpleItem(ModItems.DIAMOND_MESH);
        this.simpleItem(ModItems.ECHO_MESH);
        this.simpleItem(ModItems.EMERALD_MESH);
        this.simpleItem(ModItems.PRISMARINE_MESH);
        this.simpleItem(ModItems.NETHERITE_MESH);
        this.simpleItem(ModItems.OBSIDIAN_MESH);
        this.simpleItem(ModItems.END_MESH);
        this.simpleItem(ModItems.HEAVY_MESH);
        this.simpleItem(ModItems.IRON_ORE_PIECE);
        this.simpleItem(ModItems.GOLD_ORE_PIECE);
        this.simpleItem(ModItems.COPPER_ORE_PIECE);
        this.simpleItem(ModItems.SILVER_ORE_PIECE);
        this.simpleItem(ModItems.TIN_ORE_PIECE);
        this.simpleItem(ModItems.LAPIS_ORE_PIECE);
        this.simpleItem(ModItems.REDSTONE_ORE_PIECE);
        this.simpleItem(ModItems.DIAMOND_ORE_PIECE);
        this.simpleItem(ModItems.EMERALD_ORE_PIECE);
        this.simpleItem(ModItems.LEAD_ORE_PIECE);
        this.simpleItem(ModItems.QUARTZ_ORE_PIECE);
        this.simpleItem(ModItems.NICKEL_ORE_PIECE);
        this.simpleItem(ModItems.ZINC_ORE_PIECE);
        this.simpleItem(ModItems.PLATINUM_ORE_PIECE);
        this.simpleItem(ModItems.OSMIUM_ORE_PIECE);
        this.simpleItem(ModItems.URANIUM_ORE_PIECE);
        this.simpleItem(ModItems.ALUMINUM_ORE_PIECE);
        this.simpleItem(ModItems.COAL_ORE_PIECE);
        this.simpleItem(ModItems.DEBRIS_ORE_PIECE);
    }

    private void simpleItem(DeferredItem<Item> item) {
        ((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"strainers", (String)("item/" + item.getId().getPath())));
    }

    private void simpleBucketItem(String name, Fluid fluid) {
        ((DynamicFluidContainerModelBuilder)((ItemModelBuilder)this.withExistingParent(name, ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"item/bucket"))).customLoader(DynamicFluidContainerModelBuilder::begin)).fluid(fluid);
    }

    private ItemModelBuilder simpleBlockItem(DeferredBlock<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"strainers", (String)("item/" + item.getId().getPath())));
    }

    public String getName() {
        return "strainers Item Models";
    }
}

