/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.common.gui;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class StorageSettingsContainerMenu
extends SettingsContainerMenu<IStorageWrapper> {
    private final BlockPos pos;
    private final boolean doubleChest;

    protected StorageSettingsContainerMenu(int windowId, Player player, BlockPos pos) {
        this(ModBlocks.SETTINGS_CONTAINER_TYPE.get(), windowId, player, pos);
    }

    protected StorageSettingsContainerMenu(MenuType<?> menuType, int windowId, Player player, BlockPos pos) {
        super(menuType, windowId, player, StorageSettingsContainerMenu.getWrapper(player.level(), pos));
        this.pos = pos;
        BlockState blockState = player.level().getBlockState(pos);
        this.doubleChest = blockState.getBlock() instanceof ChestBlock && blockState.getValue(ChestBlock.TYPE) != ChestType.SINGLE;
    }

    private static IStorageWrapper getWrapper(Level level, BlockPos pos) {
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).map(be -> be.getStorageWrapper()).orElse((IStorageWrapper)NoopStorageWrapper.INSTANCE);
    }

    public void detectSettingsChangeAndReload() {
    }

    public static StorageSettingsContainerMenu fromBuffer(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new StorageSettingsContainerMenu(windowId, playerInventory.player, buffer.readBlockPos());
    }

    public BlockPos getBlockPosition() {
        return this.pos;
    }

    public boolean supportsItemDisplaySideSelection() {
        return this.doubleChest;
    }
}

