/*
 * Decompiled with CFR 0.152.
 */
package dev.gacbl.bblroutersfacade.network;

import com.mojang.serialization.DynamicOps;
import dev.gacbl.bblroutersfacade.network.ClientHandlers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="bblroutersfacade")
public final class FacadePayloads {
    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent e) {
        e.registrar("bblroutersfacade").playToClient(FacadeRefresh.TYPE, FacadeRefresh.STREAM_CODEC, (msg, ctx) -> ClientHandlers.handleRefresh(msg));
    }

    public record FacadeRefresh(BlockPos pos, @Nullable BlockState state) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<FacadeRefresh> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"bblroutersfacade", (String)"facade_refresh"));
        public static final StreamCodec<FriendlyByteBuf, FacadeRefresh> STREAM_CODEC = StreamCodec.of((buf, m) -> {
            buf.writeBlockPos(m.pos());
            buf.writeBoolean(m.state() != null);
            if (m.state() != null) {
                CompoundTag tag = (CompoundTag)BlockState.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)m.state()).getOrThrow();
                buf.writeNbt((Tag)tag);
            }
        }, buf -> {
            BlockPos p = buf.readBlockPos();
            BlockState st = null;
            if (buf.readBoolean()) {
                CompoundTag t = buf.readNbt();
                st = BlockState.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)t).result().orElse(null);
            }
            return new FacadeRefresh(p, st);
        });

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

