/*
 * Decompiled with CFR 0.152.
 */
package dev.gacbl.bblroutersfacade.network;

import dev.gacbl.bblroutersfacade.facade.FacadeAttachments;
import dev.gacbl.bblroutersfacade.network.FacadePayloads;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public final class ClientHandlers {
    public static void handleRefresh(FacadePayloads.FacadeRefresh msg) {
        Minecraft mc = Minecraft.getInstance();
        mc.execute(() -> {
            if (mc.level == null) {
                return;
            }
            BlockEntity be = mc.level.getBlockEntity(msg.pos());
            if (be != null) {
                if (msg.state() == null) {
                    be.removeData(FacadeAttachments.FACADE_STATE.get());
                } else {
                    be.setData(FacadeAttachments.FACADE_STATE.get(), (Object)msg.state());
                }
                be.requestModelDataUpdate();
            }
            BlockState bs = mc.level.getBlockState(msg.pos());
            mc.level.sendBlockUpdated(msg.pos(), bs, bs, 3);
            ClientHandlers.updateNeighborModels(mc, msg.pos());
        });
    }

    private static void updateNeighborModels(Minecraft mc, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockEntity neighborBe;
            BlockPos neighborPos = pos.relative(direction);
            if (mc.level == null || (neighborBe = mc.level.getBlockEntity(neighborPos)) == null) continue;
            neighborBe.requestModelDataUpdate();
            BlockState bs = mc.level.getBlockState(neighborPos);
            mc.level.sendBlockUpdated(neighborPos, bs, bs, 2);
        }
    }
}

