/*
 * Decompiled with CFR 0.152.
 */
package dev.gacbl.bblroutersfacade.item;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.gacbl.bblroutersfacade.facade.FacadeOps;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacadeApplicatorItem
extends Item {
    private static final String TAG_STATE = "picked_state";

    public FacadeApplicatorItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            FacadeApplicatorItem.clearPicked(stack);
            player.displayClientMessage((Component)Component.translatable((String)"item.bblroutersfacade.facade_applicator.actions.cleared_picked_facade"), true);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        ResourceLocation id;
        Level level = ctx.getLevel();
        Player player = ctx.getPlayer();
        ItemStack stack = ctx.getItemInHand();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockPos pos = ctx.getClickedPos();
        BlockState state = level.getBlockState(pos);
        boolean sneaking = player.isShiftKeyDown();
        boolean isRouter = FacadeApplicatorItem.isRouterBlock(state);
        if (isRouter && sneaking) {
            BlockState picked = FacadeApplicatorItem.getPickedState(stack);
            if (picked == null) {
                if (!level.isClientSide) {
                    FacadeOps.clear(level, pos);
                    player.displayClientMessage((Component)Component.translatable((String)"item.bblroutersfacade.facade_applicator.actions.cleared_facade"), true);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (!level.isClientSide) {
                FacadeOps.apply(level, pos, picked);
                String key = stack.getItem().getDescriptionId();
                player.displayClientMessage((Component)Component.translatable((String)"item.bblroutersfacade.facade_applicator.actions.applied_facade", (Object[])new Object[]{Component.translatable((String)key)}), true);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (!sneaking && !isRouter && (id = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock())) != null) {
            if (!level.isClientSide) {
                FacadeApplicatorItem.setPickedState(stack, state);
                String key = Util.makeDescriptionId((String)"block", (ResourceLocation)id);
                player.displayClientMessage((Component)Component.translatable((String)"item.bblroutersfacade.facade_applicator.actions.picked_facade", (Object[])new Object[]{Component.translatable((String)key)}), true);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    private static boolean isRouterBlock(BlockState s) {
        ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)s.getBlock());
        return "routers".equals(key.getNamespace());
    }

    private static void setPickedState(ItemStack stack, BlockState state) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        CompoundTag enc = (CompoundTag)BlockState.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)state).getOrThrow();
        tag.put(TAG_STATE, (Tag)enc);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    @Nullable
    private static BlockState getPickedState(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            return null;
        }
        CompoundTag root = data.copyTag();
        if (!root.contains(TAG_STATE)) {
            return null;
        }
        DataResult res = BlockState.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)root.get(TAG_STATE));
        return res.result().orElse(null);
    }

    private static void clearPicked(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            return;
        }
        CompoundTag root = data.copyTag();
        root.remove(TAG_STATE);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)root));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.bblroutersfacade.facade_applicator.right_click"));
        tooltipComponents.add((Component)Component.translatable((String)"item.bblroutersfacade.facade_applicator.shift_right_click"));
        tooltipComponents.add((Component)Component.translatable((String)"item.bblroutersfacade.facade_applicator.right_click_air"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

