/*
 * Decompiled with CFR 0.152.
 */
package dev.gacbl.bblroutersfacade.facade;

import dev.gacbl.bblroutersfacade.facade.FacadeAttachments;
import dev.gacbl.bblroutersfacade.network.FacadePayloads;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

public final class FacadeOps {
    public static void apply(Level level, BlockPos pos, BlockState facade) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be == null || facade == null) {
            return;
        }
        be.setData(FacadeAttachments.FACADE_STATE.get(), (Object)facade);
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            BlockState bs = sl.getBlockState(pos);
            sl.sendBlockUpdated(pos, bs, bs, 3);
            sl.getChunkSource().blockChanged(pos);
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)sl, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new FacadePayloads.FacadeRefresh(pos, facade), (CustomPacketPayload[])new CustomPacketPayload[0]);
            be.requestModelDataUpdate();
            FacadeOps.updateNearbyBlocks(sl, pos);
        }
    }

    public static void clear(Level level, BlockPos pos) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be == null) {
            return;
        }
        be.removeData(FacadeAttachments.FACADE_STATE.get());
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            BlockState bs = sl.getBlockState(pos);
            sl.sendBlockUpdated(pos, bs, bs, 3);
            sl.getChunkSource().blockChanged(pos);
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)sl, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new FacadePayloads.FacadeRefresh(pos, null), (CustomPacketPayload[])new CustomPacketPayload[0]);
            be.requestModelDataUpdate();
            FacadeOps.updateNearbyBlocks(sl, pos);
        }
    }

    private static void updateNearbyBlocks(ServerLevel level, BlockPos centerPos) {
        Block centerBlock = level.getBlockState(centerPos).getBlock();
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = centerPos.relative(direction);
            level.blockUpdated(neighborPos, centerBlock);
        }
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos updatePos = centerPos.offset(x, y, z);
                    BlockEntity be = level.getBlockEntity(updatePos);
                    if (be == null) continue;
                    be.requestModelDataUpdate();
                    BlockState currentState = level.getBlockState(updatePos);
                    level.sendBlockUpdated(updatePos, currentState, currentState, 2);
                }
            }
        }
    }
}

