/*
 * Decompiled with CFR 0.152.
 */
package dev.gacbl.bblroutersfacade.facade;

import dev.gacbl.bblroutersfacade.facade.FacadeAttachments;
import dev.gacbl.bblroutersfacade.facade.FacadeConnectionHelper;
import dev.gacbl.bblroutersfacade.facade.FacadeLevelWrapper;
import dev.gacbl.bblroutersfacade.facade.FacadeModelData;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacadeModelWrapper
extends BakedModelWrapper<BakedModel> {
    private final Function<BlockState, BakedModel> lookup;

    public FacadeModelWrapper(BakedModel original, Function<BlockState, BakedModel> lookup) {
        super(original);
        this.lookup = lookup;
    }

    @NotNull
    public ModelData getModelData(BlockAndTintGetter view, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData existing) {
        BlockState camo;
        BlockEntity be = view.getBlockEntity(pos);
        if (be != null && (camo = (BlockState)be.getData(FacadeAttachments.FACADE_STATE.get())) != null) {
            BakedModel camoModel = this.lookup.apply(camo);
            FacadeLevelWrapper wrappedView = new FacadeLevelWrapper(view);
            ModelData camoData = camoModel.getModelData((BlockAndTintGetter)wrappedView, pos, camo, ModelData.EMPTY);
            BlockState connectedState = this.getConnectedState(view, pos, camo);
            return existing.derive().with(FacadeModelData.FACADE, (Object)connectedState).with(FacadeModelData.CAMO_MODEL_DATA, (Object)camoData).with(FacadeConnectionHelper.ROUTER_POS_PROPERTY, (Object)pos).build();
        }
        return existing;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, ModelData data, @Nullable RenderType layer) {
        BlockState camo = (BlockState)data.get(FacadeModelData.FACADE);
        ModelData camoData = (ModelData)data.get(FacadeModelData.CAMO_MODEL_DATA);
        if (camo != null) {
            BakedModel model = this.lookup.apply(camo);
            ModelData modelData = camoData != null ? camoData : ModelData.EMPTY;
            return model.getQuads(camo, side, rand, modelData, layer);
        }
        return super.getQuads(state, side, rand, data, layer);
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, ModelData data) {
        BlockState camo = (BlockState)data.get(FacadeModelData.FACADE);
        ModelData camoData = (ModelData)data.get(FacadeModelData.CAMO_MODEL_DATA);
        if (camo != null) {
            BakedModel model = this.lookup.apply(camo);
            ModelData modelData = camoData != null ? camoData : ModelData.EMPTY;
            return model.getRenderTypes(camo, rand, modelData);
        }
        return super.getRenderTypes(state, rand, data);
    }

    private BlockState getConnectedState(BlockAndTintGetter level, BlockPos pos, BlockState camoState) {
        Block block = camoState.getBlock();
        BlockState connectedState = camoState;
        if (block instanceof FenceBlock) {
            connectedState = this.updateFenceConnections(level, pos, connectedState);
        } else if (block instanceof IronBarsBlock) {
            connectedState = this.updatePaneConnections(level, pos, connectedState);
        } else if (block instanceof WallBlock) {
            connectedState = this.updateWallConnections(level, pos, connectedState);
        }
        return connectedState;
    }

    private BlockState updateFenceConnections(BlockAndTintGetter level, BlockPos pos, BlockState state) {
        boolean north = this.canConnectToBlock(level, pos, Direction.NORTH, state.getBlock());
        boolean south = this.canConnectToBlock(level, pos, Direction.SOUTH, state.getBlock());
        boolean east = this.canConnectToBlock(level, pos, Direction.EAST, state.getBlock());
        boolean west = this.canConnectToBlock(level, pos, Direction.WEST, state.getBlock());
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)FenceBlock.NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)FenceBlock.SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)FenceBlock.EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)FenceBlock.WEST, (Comparable)Boolean.valueOf(west));
    }

    private BlockState updatePaneConnections(BlockAndTintGetter level, BlockPos pos, BlockState state) {
        boolean north = this.canConnectToBlock(level, pos, Direction.NORTH, state.getBlock());
        boolean south = this.canConnectToBlock(level, pos, Direction.SOUTH, state.getBlock());
        boolean east = this.canConnectToBlock(level, pos, Direction.EAST, state.getBlock());
        boolean west = this.canConnectToBlock(level, pos, Direction.WEST, state.getBlock());
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)IronBarsBlock.NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)IronBarsBlock.SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)IronBarsBlock.EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)IronBarsBlock.WEST, (Comparable)Boolean.valueOf(west));
    }

    private BlockState updateWallConnections(BlockAndTintGetter level, BlockPos pos, BlockState state) {
        boolean north = this.canConnectToBlock(level, pos, Direction.NORTH, state.getBlock());
        boolean south = this.canConnectToBlock(level, pos, Direction.SOUTH, state.getBlock());
        boolean east = this.canConnectToBlock(level, pos, Direction.EAST, state.getBlock());
        boolean west = this.canConnectToBlock(level, pos, Direction.WEST, state.getBlock());
        for (Property property : state.getProperties()) {
            if (!(property instanceof EnumProperty) || !property.getName().contains("north")) continue;
            String baseName = property.getName().replace("north", "");
            EnumProperty<WallSide> northProp = this.findWallProperty(state, baseName + "north");
            EnumProperty<WallSide> southProp = this.findWallProperty(state, baseName + "south");
            EnumProperty<WallSide> eastProp = this.findWallProperty(state, baseName + "east");
            EnumProperty<WallSide> westProp = this.findWallProperty(state, baseName + "west");
            if (northProp != null) {
                state = (BlockState)state.setValue(northProp, (Comparable)(north ? WallSide.LOW : WallSide.NONE));
            }
            if (southProp != null) {
                state = (BlockState)state.setValue(southProp, (Comparable)(south ? WallSide.LOW : WallSide.NONE));
            }
            if (eastProp != null) {
                state = (BlockState)state.setValue(eastProp, (Comparable)(east ? WallSide.LOW : WallSide.NONE));
            }
            if (westProp == null) break;
            state = (BlockState)state.setValue(westProp, (Comparable)(west ? WallSide.LOW : WallSide.NONE));
            break;
        }
        return state;
    }

    private EnumProperty<WallSide> findWallProperty(BlockState state, String propertyName) {
        for (Property property : state.getProperties()) {
            if (!(property instanceof EnumProperty) || !property.getName().equals(propertyName)) continue;
            return (EnumProperty)property;
        }
        return null;
    }

    private boolean canConnectToBlock(BlockAndTintGetter level, BlockPos pos, Direction direction, Block block) {
        return FacadeConnectionHelper.getConnectionState((BlockGetter)level, pos, direction, block);
    }

    private static BakedModel bakedFor(BlockState s) {
        ModelResourceLocation mrl = BlockModelShaper.stateToModelLocation((BlockState)s);
        return Minecraft.getInstance().getModelManager().getModel(mrl);
    }

    public static FacadeModelWrapper wrap(BakedModel original) {
        return new FacadeModelWrapper(original, FacadeModelWrapper::bakedFor);
    }
}

