/*
 * Decompiled with CFR 0.152.
 */
package dev.gacbl.bblroutersfacade.facade;

import dev.gacbl.bblroutersfacade.facade.FacadeAttachments;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacadeLevelWrapper
implements BlockAndTintGetter {
    private final BlockAndTintGetter delegate;

    public FacadeLevelWrapper(BlockAndTintGetter delegate) {
        this.delegate = delegate;
    }

    @NotNull
    public BlockState getBlockState(@NotNull BlockPos pos) {
        BlockEntity be;
        BlockState originalState = this.delegate.getBlockState(pos);
        BlockState spoofedState = this.getSpoofedBlockState(pos);
        if (!spoofedState.equals(originalState) && (be = this.delegate.getBlockEntity(pos)) != null) {
            BlockState blockState = (BlockState)be.getData(FacadeAttachments.FACADE_STATE.get());
        }
        return spoofedState;
    }

    @Nullable
    public BlockEntity getBlockEntity(@NotNull BlockPos pos) {
        BlockState spoofedState = this.getSpoofedBlockState(pos);
        if (spoofedState != this.delegate.getBlockState(pos)) {
            return null;
        }
        return this.delegate.getBlockEntity(pos);
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockPos pos) {
        BlockState originalState;
        BlockState spoofedState = this.getSpoofedBlockState(pos);
        if (!spoofedState.equals(originalState = this.delegate.getBlockState(pos))) {
            ModelData originalData = this.delegate.getModelData(pos);
            BakedModel spoofedModel = Minecraft.getInstance().getModelManager().getBlockModelShaper().getBlockModel(spoofedState);
            if (spoofedModel != null) {
                ModelData spoofedData = spoofedModel.getModelData((BlockAndTintGetter)this, pos, spoofedState, ModelData.EMPTY);
                return spoofedData;
            }
            return originalData;
        }
        return this.delegate.getModelData(pos);
    }

    private BlockState getSpoofedBlockState(BlockPos pos) {
        BlockPos[] facadePositions;
        BlockState facadeState;
        BlockEntity be = this.delegate.getBlockEntity(pos);
        if (be != null && (facadeState = (BlockState)be.getData(FacadeAttachments.FACADE_STATE.get())) != null) {
            return facadeState;
        }
        for (BlockPos facadePos : facadePositions = new BlockPos[]{new BlockPos(0, 58, -9), new BlockPos(0, 57, -9)}) {
            BlockState neighborFacade;
            BlockEntity facadeBe;
            if (!pos.closerThan((Vec3i)facadePos, 2.0) || (facadeBe = this.delegate.getBlockEntity(facadePos)) == null || (neighborFacade = (BlockState)facadeBe.getData(FacadeAttachments.FACADE_STATE.get())) == null || !"connectedglass".equals(BuiltInRegistries.BLOCK.getKey((Object)neighborFacade.getBlock()).getNamespace())) continue;
            return neighborFacade;
        }
        return this.delegate.getBlockState(pos);
    }

    @NotNull
    public FluidState getFluidState(@NotNull BlockPos blockPos) {
        return this.delegate.getFluidState(blockPos);
    }

    public int getLightEmission(@NotNull BlockPos pos) {
        return this.delegate.getLightEmission(pos);
    }

    public float getShade(@NotNull Direction direction, boolean bl) {
        return this.delegate.getShade(direction, bl);
    }

    @NotNull
    public LevelLightEngine getLightEngine() {
        return this.delegate.getLightEngine();
    }

    public int getBlockTint(@NotNull BlockPos blockPos, @NotNull ColorResolver colorResolver) {
        return this.delegate.getBlockTint(blockPos, colorResolver);
    }

    public int getHeight() {
        return this.delegate.getHeight();
    }

    public int getMinBuildHeight() {
        return this.delegate.getMinBuildHeight();
    }
}

