/*
 * Decompiled with CFR 0.152.
 */
package dev.gacbl.bblroutersfacade.facade;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.gacbl.bblroutersfacade.facade.FacadeAttachments;
import dev.gacbl.bblroutersfacade.item.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@EventBusSubscriber(modid="bblroutersfacade", value={Dist.CLIENT})
public final class FacadeHighlighter {
    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent e) {
        if (e.getStage() != RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        if (!FacadeHighlighter.isHoldingApplicator(mc.player.getMainHandItem()) && !FacadeHighlighter.isHoldingApplicator(mc.player.getOffhandItem())) {
            return;
        }
        PoseStack pose = e.getPoseStack();
        Vec3 cam = e.getCamera().getPosition();
        MultiBufferSource.BufferSource buffers = mc.renderBuffers().bufferSource();
        VertexConsumer lines = buffers.getBuffer(RenderType.lines());
        pose.pushPose();
        int r = 32;
        BlockPos c = mc.player.blockPosition();
        BlockPos.betweenClosedStream((BlockPos)c.offset(-r, -r, -r), (BlockPos)c.offset(r, r, r)).forEach(p -> {
            BlockEntity be = mc.level.getBlockEntity(p);
            if (be == null) {
                return;
            }
            if (be.getData(FacadeAttachments.FACADE_STATE.get()) == null) {
                return;
            }
            pose.pushPose();
            pose.translate((double)p.getX() - cam.x, (double)p.getY() - cam.y, (double)p.getZ() - cam.z);
            AABB box = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).inflate(0.002);
            LevelRenderer.renderLineBox((PoseStack)pose, (VertexConsumer)lines, (AABB)box, (float)0.2f, (float)0.6f, (float)1.0f, (float)1.0f);
            pose.popPose();
        });
        pose.popPose();
        buffers.endBatch(RenderType.lines());
    }

    private static boolean isHoldingApplicator(ItemStack stack) {
        return stack.is(ModItems.FACADE_APPLICATOR.get());
    }
}

