/*
 * Decompiled with CFR 0.152.
 */
package dev.gacbl.bblroutersfacade.facade;

import dev.gacbl.bblroutersfacade.facade.FacadeAttachments;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;

public class FacadeConnectionHelper {
    @NotNull
    public static final ModelProperty<BlockState> FACADE_STATE_PROPERTY = new ModelProperty();
    @NotNull
    public static final ModelProperty<BlockPos> ROUTER_POS_PROPERTY = new ModelProperty();

    public static boolean shouldConnectToFacade(BlockGetter level, BlockPos pos, Direction direction, Block block) {
        BlockState neighborFacade;
        BlockPos neighborPos = pos.relative(direction);
        BlockEntity neighborBe = level.getBlockEntity(neighborPos);
        if (neighborBe != null && (neighborFacade = (BlockState)neighborBe.getData(FacadeAttachments.FACADE_STATE.get())) != null) {
            Block facadeBlock = neighborFacade.getBlock();
            if (block == facadeBlock) {
                return true;
            }
            String blockNamespace = BuiltInRegistries.BLOCK.getKey((Object)block).getNamespace();
            String facadeNamespace = BuiltInRegistries.BLOCK.getKey((Object)facadeBlock).getNamespace();
            if ("connectedglass".equals(blockNamespace) && blockNamespace.equals(facadeNamespace)) {
                return true;
            }
            if (block instanceof FenceBlock && facadeBlock instanceof FenceBlock) {
                return true;
            }
            if (block instanceof IronBarsBlock && facadeBlock instanceof IronBarsBlock) {
                return true;
            }
            if (block instanceof WallBlock && facadeBlock instanceof WallBlock) {
                return true;
            }
        }
        return false;
    }

    public static boolean getConnectionState(BlockGetter level, BlockPos pos, Direction direction, Block block) {
        BlockPos neighborPos = pos.relative(direction);
        BlockState neighborState = level.getBlockState(neighborPos);
        Block neighborBlock = neighborState.getBlock();
        boolean vanillaConnection = false;
        if (block instanceof FenceBlock) {
            vanillaConnection = neighborBlock instanceof FenceBlock || neighborState.isFaceSturdy(level, neighborPos, direction.getOpposite());
        } else if (block instanceof IronBarsBlock) {
            vanillaConnection = neighborBlock instanceof IronBarsBlock || neighborState.isFaceSturdy(level, neighborPos, direction.getOpposite());
        } else if (block instanceof WallBlock) {
            vanillaConnection = neighborBlock instanceof WallBlock || neighborState.isFaceSturdy(level, neighborPos, direction.getOpposite());
        }
        boolean facadeConnection = FacadeConnectionHelper.shouldConnectToFacade(level, pos, direction, block);
        return vanillaConnection || facadeConnection;
    }
}

