/*
 * Decompiled with CFR 0.152.
 */
package dev.gacbl.bblroutersfacade.facade;

import dev.gacbl.bblroutersfacade.facade.FacadeAttachments;
import java.util.List;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

@EventBusSubscriber(modid="bblroutersfacade", value={Dist.CLIENT})
public final class FacadeColorForwarder {
    @SubscribeEvent
    public static void onBlockColors(RegisterColorHandlersEvent.Block e) {
        BlockColors colors = e.getBlockColors();
        List<Block> routerBlocks = BuiltInRegistries.BLOCK.stream().filter(b -> BuiltInRegistries.BLOCK.getKey(b).getNamespace().equals("routers")).toList();
        if (routerBlocks.isEmpty()) {
            return;
        }
        e.register((state, level, pos, tintIndex) -> {
            if (level == null || pos == null) {
                return -1;
            }
            BlockEntity be = level.getBlockEntity(pos);
            if (be == null) {
                return -1;
            }
            BlockState camo = (BlockState)be.getData(FacadeAttachments.FACADE_STATE.get());
            if (camo == null) {
                return -1;
            }
            return colors.getColor(camo, level, pos, tintIndex);
        }, (Block[])routerBlocks.toArray(Block[]::new));
    }
}

