/*
 * Decompiled with CFR 0.152.
 */
package dev.gacbl.bblroutersfacade.facade;

import dev.gacbl.bblroutersfacade.facade.FacadeConnectionHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="bblroutersfacade")
public class FacadeBlockUpdater {
    @SubscribeEvent
    public static void onBlockUpdate(BlockEvent.NeighborNotifyEvent event) {
        Level level = (Level)event.getLevel();
        if (level.isClientSide) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        Block block = state.getBlock();
        FacadeBlockUpdater.updateBlockConnections((ServerLevel)level, pos, state, block);
    }

    private static void updateBlockConnections(ServerLevel level, BlockPos pos, BlockState currentState, Block block) {
        boolean shouldConnectUp;
        BlockState newState = currentState;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            boolean shouldConnectToFacade = FacadeConnectionHelper.shouldConnectToFacade((BlockGetter)level, pos, direction, block);
            if (!(block instanceof WallBlock)) continue;
            Property<WallSide> wallSideProperty = FacadeBlockUpdater.getHorizontalWallProperty(direction);
            if (shouldConnectToFacade) {
                WallSide existingSide = (WallSide)newState.getValue(wallSideProperty);
                newState = (BlockState)newState.setValue(wallSideProperty, (Comparable)(existingSide == WallSide.TALL ? WallSide.TALL : WallSide.LOW));
                continue;
            }
            BlockPos neighborPos = pos.relative(direction);
            BlockState neighborState = level.getBlockState(neighborPos);
            boolean isConnectedToVanilla = neighborState.getBlock() instanceof WallBlock || neighborState.isFaceSturdy((BlockGetter)level, neighborPos, direction.getOpposite());
            if (isConnectedToVanilla) continue;
            newState = (BlockState)newState.setValue(wallSideProperty, (Comparable)WallSide.NONE);
        }
        if (block instanceof WallBlock && (shouldConnectUp = FacadeConnectionHelper.shouldConnectToFacade((BlockGetter)level, pos, Direction.UP, block))) {
            newState = (BlockState)newState.setValue((Property)WallBlock.UP, (Comparable)Boolean.valueOf(true));
        }
        if (block instanceof WallBlock && !newState.equals(currentState)) {
            level.setBlock(pos, newState, 3);
        }
    }

    private static Property<WallSide> getHorizontalWallProperty(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> WallBlock.NORTH_WALL;
            case Direction.SOUTH -> WallBlock.SOUTH_WALL;
            case Direction.EAST -> WallBlock.EAST_WALL;
            case Direction.WEST -> WallBlock.WEST_WALL;
            default -> throw new IllegalArgumentException("Invalid horizontal direction: " + String.valueOf(direction));
        };
    }
}

