/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunters_return.data.resources.registries;

import baguchan.hunters_return.HuntersReturn;
import baguchan.hunters_return.api.HunterVariant;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.Tags;

public class HunterVariants {
    public static final ResourceKey<Registry<HunterVariant>> HUNTER_VARIANT_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hunters_return", (String)"hunter_variant"));
    public static final ResourceKey<HunterVariant> NORMAL = HunterVariants.createKey("normal");
    public static final ResourceKey<HunterVariant> COLD = HunterVariants.createKey("cold");
    public static final ResourceKey<HunterVariant> SWAMP = HunterVariants.createKey("swamp");
    public static final ResourceKey<HunterVariant> DEFAULT = NORMAL;

    private static ResourceKey<HunterVariant> createKey(String name) {
        return ResourceKey.create(HUNTER_VARIANT_KEY, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hunters_return", (String)name));
    }

    static void register(BootstrapContext<HunterVariant> context, ResourceKey<HunterVariant> key, String name, ResourceKey<Biome> biomeResourceKey) {
        HunterVariants.register(context, key, name, (HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.BIOME).getOrThrow(biomeResourceKey)}));
    }

    static void register(BootstrapContext<HunterVariant> context, ResourceKey<HunterVariant> key, String name, TagKey<Biome> biomeTag) {
        HunterVariants.register(context, key, name, (HolderSet<Biome>)context.lookup(Registries.BIOME).getOrThrow(biomeTag));
    }

    static void registerWithoutOld(BootstrapContext<HunterVariant> context, ResourceKey<HunterVariant> key, String name, TagKey<Biome> biomeTag) {
        HunterVariants.registerWithoutOld(context, key, name, (HolderSet<Biome>)context.lookup(Registries.BIOME).getOrThrow(biomeTag));
    }

    static void register(BootstrapContext<HunterVariant> context, ResourceKey<HunterVariant> key, String name, HolderSet<Biome> biomeHolderSet) {
        ResourceLocation resourcelocation = HuntersReturn.locate("entity/hunter/" + name);
        ResourceLocation resourcelocation2 = HuntersReturn.locate("entity/hunter/" + name + "_old");
        context.register(key, (Object)new HunterVariant(resourcelocation, Optional.of(resourcelocation2), biomeHolderSet));
    }

    static void registerWithoutOld(BootstrapContext<HunterVariant> context, ResourceKey<HunterVariant> key, String name, HolderSet<Biome> biomeHolderSet) {
        ResourceLocation resourcelocation = HuntersReturn.locate("entity/hunter/" + name);
        context.register(key, (Object)new HunterVariant(resourcelocation, Optional.empty(), biomeHolderSet));
    }

    public static Holder<HunterVariant> getSpawnVariant(RegistryAccess p_332694_, Holder<Biome> p_332773_) {
        Registry registry = p_332694_.registryOrThrow(HUNTER_VARIANT_KEY);
        return (Holder)registry.holders().filter(p_332674_ -> ((HunterVariant)p_332674_.value()).biomes().contains(p_332773_)).findFirst().or(() -> registry.getHolder(DEFAULT)).or(() -> ((Registry)registry).getAny()).orElseThrow();
    }

    public static void bootstrap(BootstrapContext<HunterVariant> context) {
        HunterVariants.register(context, NORMAL, "normal", (HolderSet<Biome>)HolderSet.empty());
        HunterVariants.register(context, COLD, "cold", (TagKey<Biome>)Tags.Biomes.IS_COLD_OVERWORLD);
        HunterVariants.registerWithoutOld(context, SWAMP, "swamp", (TagKey<Biome>)Tags.Biomes.IS_SWAMP);
    }
}

