/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunters_return.data;

import baguchan.hunters_return.data.BiomeTagGenerator;
import baguchan.hunters_return.data.BlockTagGenerator;
import baguchan.hunters_return.data.CraftingGenerator;
import baguchan.hunters_return.data.EntityTagGenerator;
import baguchan.hunters_return.data.ItemTagGenerator;
import baguchan.hunters_return.data.RegistryDataGenerator;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="hunters_return")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        event.getGenerator().addProvider(true, (DataProvider)new RegistryDataGenerator(packOutput, lookupProvider));
        BlockTagGenerator blocktags = new BlockTagGenerator(packOutput, lookupProvider, existingFileHelper);
        event.getGenerator().addProvider(true, (DataProvider)blocktags);
        event.getGenerator().addProvider(true, (DataProvider)new ItemTagGenerator(packOutput, lookupProvider, blocktags.contentsGetter(), existingFileHelper));
        event.getGenerator().addProvider(true, (DataProvider)new EntityTagGenerator(packOutput, lookupProvider, existingFileHelper));
        event.getGenerator().addProvider(true, (DataProvider)new BiomeTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new CraftingGenerator(packOutput, lookupProvider));
    }
}

